/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.enhance.impl.ImplEnhanceFilter;
import boofcv.alg.enhance.impl.ImplEnhanceFilter_MT;
import boofcv.alg.enhance.impl.ImplEnhanceHistogram;
import boofcv.alg.enhance.impl.ImplEnhanceHistogram_MT;
import boofcv.alg.misc.ImageStatistics;
import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class EnhanceImageOps {
    public static Kernel2D_S32 kernelEnhance4_I32 = new Kernel2D_S32(3, new int[]{0, -1, 0, -1, 5, -1, 0, -1, 0});
    public static Kernel2D_F32 kernelEnhance4_F32 = new Kernel2D_F32(3, new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f});
    public static Kernel2D_S32 kernelEnhance8_I32 = new Kernel2D_S32(3, new int[]{-1, -1, -1, -1, 9, -1, -1, -1, -1});
    public static Kernel2D_F32 kernelEnhance8_F32 = new Kernel2D_F32(3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});

    public static void equalize(int[] histogram, int[] transform) {
        int sum = 0;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        int maxValue = histogram.length - 1;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = transform[i] * maxValue / sum;
        }
    }

    public static void applyTransform(GrayU8 input, int[] transform, GrayU8 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceHistogram_MT.applyTransform(input, transform, output);
        } else {
            ImplEnhanceHistogram.applyTransform(input, transform, output);
        }
    }

    public static void applyTransform(GrayU16 input, int[] transform, GrayU16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceHistogram_MT.applyTransform(input, transform, output);
        } else {
            ImplEnhanceHistogram.applyTransform(input, transform, output);
        }
    }

    public static void applyTransform(GrayS8 input, int[] transform, int minValue, GrayS8 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceHistogram_MT.applyTransform(input, transform, minValue, output);
        } else {
            ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
        }
    }

    public static void applyTransform(GrayS16 input, int[] transform, int minValue, GrayS16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceHistogram_MT.applyTransform(input, transform, minValue, output);
        } else {
            ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
        }
    }

    public static void applyTransform(GrayS32 input, int[] transform, int minValue, GrayS32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceHistogram_MT.applyTransform(input, transform, minValue, output);
        } else {
            ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
        }
    }

    public static void equalizeLocal(GrayU8 input, int radius, GrayU8 output, int histogramLength, @Nullable GrowArray<DogArray_I32> workspaces) {
        output.reshape(input.width, input.height);
        workspaces = BoofMiscOps.checkDeclare(workspaces, DogArray_I32::new);
        int width = radius * 2 + 1;
        if (input.width >= width && input.height >= width) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplEnhanceHistogram_MT.equalizeLocalInner(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalRow(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalRow(input, radius, histogramLength, input.height - radius, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalCol(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalCol(input, radius, histogramLength, input.width - radius, output, (GrowArray<DogArray_I32>)workspaces);
            } else {
                ImplEnhanceHistogram.equalizeLocalInner(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalRow(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalRow(input, radius, histogramLength, input.height - radius, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalCol(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalCol(input, radius, histogramLength, input.width - radius, output, (GrowArray<DogArray_I32>)workspaces);
            }
        } else if (input.width < width && input.height < width) {
            workspaces.reset();
            int[] histogram = BoofMiscOps.checkDeclare((DogArray_I32)((DogArray_I32)workspaces.grow()), (int)histogramLength, (boolean)false);
            int[] transform = BoofMiscOps.checkDeclare((DogArray_I32)((DogArray_I32)workspaces.grow()), (int)histogramLength, (boolean)false);
            ImageStatistics.histogram(input, 0, histogram);
            EnhanceImageOps.equalize(histogram, transform);
            EnhanceImageOps.applyTransform(input, transform, output);
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceHistogram_MT.equalizeLocalNaive(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
        } else {
            ImplEnhanceHistogram.equalizeLocalNaive(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
        }
    }

    public static void equalizeLocal(GrayU16 input, int radius, GrayU16 output, int histogramLength, @Nullable GrowArray<DogArray_I32> workspaces) {
        InputSanityCheck.checkReshape((ImageBase)input, (ImageBase)output);
        workspaces = BoofMiscOps.checkDeclare(workspaces, DogArray_I32::new);
        int width = radius * 2 + 1;
        if (input.width >= width && input.height >= width) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplEnhanceHistogram_MT.equalizeLocalInner(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalRow(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalRow(input, radius, histogramLength, input.height - radius, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalCol(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram_MT.equalizeLocalCol(input, radius, histogramLength, input.width - radius, output, (GrowArray<DogArray_I32>)workspaces);
            } else {
                ImplEnhanceHistogram.equalizeLocalInner(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalRow(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalRow(input, radius, histogramLength, input.height - radius, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalCol(input, radius, histogramLength, 0, output, (GrowArray<DogArray_I32>)workspaces);
                ImplEnhanceHistogram.equalizeLocalCol(input, radius, histogramLength, input.width - radius, output, (GrowArray<DogArray_I32>)workspaces);
            }
        } else if (input.width < width && input.height < width) {
            workspaces.reset();
            int[] histogram = BoofMiscOps.checkDeclare((DogArray_I32)((DogArray_I32)workspaces.grow()), (int)histogramLength, (boolean)false);
            int[] transform = BoofMiscOps.checkDeclare((DogArray_I32)((DogArray_I32)workspaces.grow()), (int)histogramLength, (boolean)false);
            ImageStatistics.histogram(input, 0, histogram);
            EnhanceImageOps.equalize(histogram, transform);
            EnhanceImageOps.applyTransform(input, transform, output);
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceHistogram_MT.equalizeLocalNaive(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
        } else {
            ImplEnhanceHistogram.equalizeLocalNaive(input, radius, histogramLength, output, (GrowArray<DogArray_I32>)workspaces);
        }
    }

    public static void sharpen4(GrayU8 input, GrayU8 output) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceFilter_MT.sharpenInner4(input, output, 0, 255);
            ImplEnhanceFilter_MT.sharpenBorder4(input, output, 0, 255);
        } else {
            ImplEnhanceFilter.sharpenInner4(input, output, 0, 255);
            ImplEnhanceFilter.sharpenBorder4(input, output, 0, 255);
        }
    }

    public static void sharpen4(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceFilter_MT.sharpenInner4(input, output, 0.0f, 255.0f);
            ImplEnhanceFilter_MT.sharpenBorder4(input, output, 0.0f, 255.0f);
        } else {
            ImplEnhanceFilter.sharpenInner4(input, output, 0.0f, 255.0f);
            ImplEnhanceFilter.sharpenBorder4(input, output, 0.0f, 255.0f);
        }
    }

    public static void sharpen8(GrayU8 input, GrayU8 output) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceFilter_MT.sharpenInner8(input, output, 0, 255);
            ImplEnhanceFilter_MT.sharpenBorder8(input, output, 0, 255);
        } else {
            ImplEnhanceFilter.sharpenInner8(input, output, 0, 255);
            ImplEnhanceFilter.sharpenBorder8(input, output, 0, 255);
        }
    }

    public static void sharpen8(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplEnhanceFilter_MT.sharpenInner8(input, output, 0.0f, 255.0f);
            ImplEnhanceFilter_MT.sharpenBorder8(input, output, 0.0f, 255.0f);
        } else {
            ImplEnhanceFilter.sharpenInner8(input, output, 0.0f, 255.0f);
            ImplEnhanceFilter.sharpenBorder8(input, output, 0.0f, 255.0f);
        }
    }
}

