/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.UrlLinkID3V2Frame;

public class WXXXUrlLinkID3V2Frame
extends UrlLinkID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sDescription = null;

    public WXXXUrlLinkID3V2Frame(String sDescription, String sUrl) throws ID3Exception {
        super(sUrl);
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sDescription == null) {
            throw new ID3Exception("Description cannot be null in WXXX frame.");
        }
        this.m_sDescription = sDescription;
        this.m_sURL = sUrl;
    }

    public WXXXUrlLinkID3V2Frame(String sDescription, URL oURL) throws ID3Exception {
        super(oURL);
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sDescription == null) {
            throw new ID3Exception("Description cannot be null in WXXX frame.");
        }
        this.m_sDescription = sDescription;
        this.m_sURL = oURL.toExternalForm();
    }

    public WXXXUrlLinkID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            this.m_sDescription = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            byte[] abyUrl = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abyUrl);
            this.m_sURL = new String(abyUrl);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitWXXXUrlLinkID3V2Frame(this);
    }

    public void setDescriptionAndUrl(String sDescription, String sUrl) throws ID3Exception {
        TextEncoding oOrigTextEncoding = this.m_oTextEncoding;
        String sOrigDescription = this.m_sDescription;
        String sOrigURL = this.m_sURL;
        if (sDescription == null) {
            throw new ID3Exception("Description cannot be null in WXXX frame.");
        }
        if (sUrl == null) {
            throw new ID3Exception("Url cannot be null in WXXX frame.");
        }
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sDescription = sDescription;
        this.m_sURL = sUrl;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_oTextEncoding = oOrigTextEncoding;
            this.m_sDescription = sOrigDescription;
            this.m_sURL = sOrigURL;
            throw e;
        }
    }

    public void setDescriptionAndUrl(String sDescription, URL oURL) throws ID3Exception {
        TextEncoding oOrigTextEncoding = this.m_oTextEncoding;
        String sOrigDescription = this.m_sDescription;
        String sOrigURL = this.m_sURL;
        if (sDescription == null) {
            throw new ID3Exception("Description cannot be null in WXXX frame.");
        }
        if (oURL == null) {
            throw new ID3Exception("URL cannot be null in WXXX frame.");
        }
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sDescription = sDescription;
        this.m_sURL = oURL.toExternalForm();
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_oTextEncoding = oOrigTextEncoding;
            this.m_sDescription = sOrigDescription;
            this.m_sURL = sOrigURL;
            throw e;
        }
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public String getUrl() {
        return this.m_sURL;
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected byte[] getFrameId() {
        return "WXXX".getBytes();
    }

    public String toString() {
        return "User-defined URL: Description=[" + this.m_sDescription + "], URL=[" + this.m_sURL + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sDescription.getBytes(this.m_oTextEncoding.getEncodingString()));
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        oIDOS.write(this.m_sURL.getBytes());
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof WXXXUrlLinkID3V2Frame)) {
            return false;
        }
        WXXXUrlLinkID3V2Frame oOtherWXXX = (WXXXUrlLinkID3V2Frame)oOther;
        return this.m_sDescription.equals(oOtherWXXX.m_sDescription) && this.m_oTextEncoding.equals(oOtherWXXX.m_oTextEncoding) && this.m_sURL.equals(oOtherWXXX.m_sURL);
    }
}

