/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.net.URL;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.UrlLinkID3V2Frame;

public class WOARUrlLinkID3V2Frame
extends UrlLinkID3V2Frame {
    public WOARUrlLinkID3V2Frame(String sOfficialArtistUrl) throws ID3Exception {
        super(sOfficialArtistUrl);
    }

    public WOARUrlLinkID3V2Frame(URL oOfficialArtistUrl) throws ID3Exception {
        super(oOfficialArtistUrl);
    }

    public WOARUrlLinkID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitWOARUrlLinkID3V2Frame(this);
    }

    public void setOfficialArtistWebPage(String sOfficialArtistUrl) throws ID3Exception {
        String sOrigURL = this.m_sURL;
        if (sOfficialArtistUrl == null) {
            throw new ID3Exception("Official artist URL string cannot be null in WOAR frame.");
        }
        this.m_sURL = sOfficialArtistUrl;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sURL = sOrigURL;
            throw e;
        }
    }

    public void setOfficialArtistWebPage(URL oOfficialArtistUrl) throws ID3Exception {
        String sOrigURL = this.m_sURL;
        if (oOfficialArtistUrl == null) {
            throw new ID3Exception("Official artist URL object cannot be null in WOAR frame.");
        }
        this.m_sURL = oOfficialArtistUrl.toExternalForm();
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sURL = sOrigURL;
            throw e;
        }
    }

    public String getOfficialArtistWebPage() {
        return this.m_sURL;
    }

    protected byte[] getFrameId() {
        return "WOAR".getBytes();
    }

    public String toString() {
        return "Official artist/performer webpage URL: [" + this.m_sURL + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof WOARUrlLinkID3V2Frame)) {
            return false;
        }
        WOARUrlLinkID3V2Frame oOtherWOAR = (WOARUrlLinkID3V2Frame)oOther;
        return this.m_sURL.equals(oOtherWOAR.m_sURL);
    }
}

