/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TSRCTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private String m_sISRC = null;

    public TSRCTextInformationID3V2Frame(String sISRC) throws ID3Exception {
        super(sISRC);
        if (sISRC.length() != 12) {
            throw new ID3Exception("ISRC code must be 12 characters long.");
        }
        this.m_sISRC = sISRC;
    }

    public TSRCTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        this.m_sISRC = this.m_sInformation;
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTSRCTextInformationID3V2Frame(this);
    }

    public void setISRC(String sISRC) throws ID3Exception {
        if (sISRC.length() != 12) {
            throw new ID3Exception("ISRC code must be 12 characters long.");
        }
        this.m_sISRC = sISRC;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sISRC;
    }

    public String getISRC() {
        return this.m_sISRC;
    }

    protected byte[] getFrameId() {
        return "TSRC".getBytes();
    }

    public String toString() {
        return "International Standard Recording Code (ISRC): [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TSRCTextInformationID3V2Frame)) {
            return false;
        }
        TSRCTextInformationID3V2Frame oOtherTSRC = (TSRCTextInformationID3V2Frame)oOther;
        return this.m_sISRC.equals(oOtherTSRC.m_sISRC) && this.m_oTextEncoding.equals(oOtherTSRC.m_oTextEncoding) && this.m_sInformation.equals(oOtherTSRC.m_sInformation);
    }
}

