/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TLENTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iLengthInMilliseconds;

    public TLENTextInformationID3V2Frame(int iLengthInMilliseconds) {
        super(Integer.toString(iLengthInMilliseconds));
        this.m_iLengthInMilliseconds = iLengthInMilliseconds;
    }

    public TLENTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            this.m_iLengthInMilliseconds = Integer.parseInt(this.m_sInformation);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered corrupt TLEN track length frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTLENTextInformationID3V2Frame(this);
    }

    public void setTrackLength(int iLengthInMilliseconds) {
        this.m_iLengthInMilliseconds = iLengthInMilliseconds;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = Integer.toString(iLengthInMilliseconds);
    }

    public int getTrackLength() {
        return this.m_iLengthInMilliseconds;
    }

    protected byte[] getFrameId() {
        return "TLEN".getBytes();
    }

    public String toString() {
        return "Length (milliseconds): [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TLENTextInformationID3V2Frame)) {
            return false;
        }
        TLENTextInformationID3V2Frame oOtherTLEN = (TLENTextInformationID3V2Frame)oOther;
        return this.m_iLengthInMilliseconds == oOtherTLEN.m_iLengthInMilliseconds && this.m_oTextEncoding.equals(oOtherTLEN.m_oTextEncoding) && this.m_sInformation.equals(oOtherTLEN.m_sInformation);
    }
}

