/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TEXTTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private String[] m_asLyricist = null;

    public TEXTTextInformationID3V2Frame(String sLyricist) {
        super(sLyricist);
        this.m_asLyricist = this.getLyricists(sLyricist);
    }

    public TEXTTextInformationID3V2Frame(String[] asLyricist) {
        super("");
        StringBuffer sbLyricists = new StringBuffer();
        for (int i = 0; i < asLyricist.length; ++i) {
            sbLyricists.append(asLyricist[i] + "/");
        }
        sbLyricists.deleteCharAt(sbLyricists.length() - 1);
        this.m_sInformation = sbLyricists.toString();
        this.m_asLyricist = this.getLyricists(this.m_sInformation);
    }

    public TEXTTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        this.m_asLyricist = this.getLyricists(this.m_sInformation);
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTEXTTextInformationID3V2Frame(this);
    }

    public void setLyricist(String sLyricist) {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sLyricist;
        this.m_asLyricist = this.getLyricists(sLyricist);
    }

    public void setLyricists(String[] asLyricist) {
        StringBuffer sbLyricists = new StringBuffer();
        for (int i = 0; i < asLyricist.length; ++i) {
            sbLyricists.append(asLyricist[i] + "/");
        }
        sbLyricists.deleteCharAt(sbLyricists.length() - 1);
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sbLyricists.toString();
        this.m_asLyricist = this.getLyricists(this.m_sInformation);
    }

    public String[] getLyricists() {
        return this.m_asLyricist;
    }

    protected byte[] getFrameId() {
        return "TEXT".getBytes();
    }

    public String toString() {
        return "Lyricist(s)/Text writer(s): [" + this.m_sInformation + "]";
    }

    private String[] getLyricists(String sValue) {
        String[] asLyricist = sValue.split("/");
        return asLyricist;
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TEXTTextInformationID3V2Frame)) {
            return false;
        }
        TEXTTextInformationID3V2Frame oOtherTEXT = (TEXTTextInformationID3V2Frame)oOther;
        return this.m_sInformation.equals(oOtherTEXT.m_sInformation) && this.m_oTextEncoding.equals(oOtherTEXT.m_oTextEncoding) && Arrays.equals(this.m_asLyricist, oOtherTEXT.m_asLyricist);
    }
}

