/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class SYTCID3V2Frame
extends ID3V2Frame {
    private TimestampFormat m_oTimestampFormat = null;
    private SortedMap m_oTempoChangeMap = null;

    public SYTCID3V2Frame(TimestampFormat oTimestampFormat) throws ID3Exception {
        if (oTimestampFormat == null) {
            throw new ID3Exception("Timestamp cannot be null in SYTC frame.");
        }
        this.m_oTimestampFormat = oTimestampFormat;
        this.m_oTempoChangeMap = new TreeMap();
    }

    public SYTCID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTimestampFormat = new TimestampFormat((byte)oFrameDataID3DIS.readUnsignedByte());
            this.m_oTempoChangeMap = new TreeMap();
            while (oFrameDataID3DIS.available() > 0) {
                int iBeatsPerMinute = oFrameDataID3DIS.readUnsignedByte();
                if (iBeatsPerMinute == 255) {
                    iBeatsPerMinute += oFrameDataID3DIS.readUnsignedByte();
                }
                int iTimestamp = oFrameDataID3DIS.readBE32();
                this.m_oTempoChangeMap.put(new Integer(iTimestamp), new Integer(iBeatsPerMinute));
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitSYTCID3V2Frame(this);
    }

    public void addTempoChange(TempoChange oTempoChange) throws ID3Exception {
        if (oTempoChange == null) {
            throw new ID3Exception("TempoChange cannot be null.");
        }
        if (this.m_oTempoChangeMap.keySet().contains(new Integer(oTempoChange.getTimestamp()))) {
            throw new ID3Exception("SYTC frame already contains a tempo change for timestamp " + oTempoChange.getTimestamp() + ".");
        }
        this.m_oTempoChangeMap.put(new Integer(oTempoChange.getTimestamp()), new Integer(oTempoChange.getBeatsPerMinute()));
    }

    public TempoChange getTempoChange(int iTimestamp) {
        if (this.m_oTempoChangeMap.keySet().contains(new Integer(iTimestamp))) {
            try {
                return new TempoChange((Integer)this.m_oTempoChangeMap.get(new Integer(iTimestamp)), iTimestamp);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public TempoChange removeTempoChange(int iTimestamp) {
        if (this.m_oTempoChangeMap.keySet().contains(new Integer(iTimestamp))) {
            try {
                return new TempoChange((Integer)this.m_oTempoChangeMap.remove(new Integer(iTimestamp)), iTimestamp);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected byte[] getFrameId() {
        return "SYTC".getBytes();
    }

    public String toString() {
        StringBuffer sbText = new StringBuffer();
        sbText.append("Synchronized tempo codes: Timestamp format=[" + this.m_oTimestampFormat.getValue() + "]");
        Iterator oIter = this.m_oTempoChangeMap.keySet().iterator();
        while (oIter.hasNext()) {
            Integer oTimestamp = (Integer)oIter.next();
            Integer oBeatsPerMinute = (Integer)this.m_oTempoChangeMap.get(oTimestamp);
            sbText.append(" TempoChange(" + oTimestamp + ", BPM=" + oBeatsPerMinute + ")");
        }
        return sbText.toString();
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_oTimestampFormat.getValue());
        Iterator oIter = this.m_oTempoChangeMap.keySet().iterator();
        while (oIter.hasNext()) {
            Integer oTimestamp = (Integer)oIter.next();
            Integer oBeatsPerMinute = (Integer)this.m_oTempoChangeMap.get(oTimestamp);
            int iBeatsPerMinute = oBeatsPerMinute;
            if (iBeatsPerMinute >= 255) {
                oIDOS.write(255);
                oIDOS.write(iBeatsPerMinute - 255);
            } else {
                oIDOS.write(iBeatsPerMinute);
            }
            oIDOS.writeBE32(oTimestamp);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof SYTCID3V2Frame)) {
            return false;
        }
        SYTCID3V2Frame oOtherSYTC = (SYTCID3V2Frame)oOther;
        return this.m_oTimestampFormat.equals(oOtherSYTC.m_oTimestampFormat) && this.m_oTempoChangeMap.equals(oOtherSYTC.m_oTempoChangeMap);
    }

    public static class TempoChange {
        private int m_iBeatsPerMinute;
        private int m_iTimestamp;

        public TempoChange(int iBeatsPerMinute, int iTimestamp) throws ID3Exception {
            if (iBeatsPerMinute < 0 || iBeatsPerMinute > 510) {
                throw new ID3Exception("Beats per minute value must be between 0 and 510 in SYTC frame.");
            }
            this.m_iBeatsPerMinute = iBeatsPerMinute;
            if (iTimestamp < 0) {
                throw new ID3Exception("Timestamp cannot be negative in sync entry in SYLT frame.");
            }
            this.m_iTimestamp = iTimestamp;
        }

        public int getBeatsPerMinute() {
            return this.m_iBeatsPerMinute;
        }

        public int getTimestamp() {
            return this.m_iTimestamp;
        }
    }

    public static class TimestampFormat {
        private byte m_byTimestampFormat;
        public static final TimestampFormat ABSOLUTE_MPEG_FRAMES = new TimestampFormat(1);
        public static final TimestampFormat ABSOLUTE_MILLISECONDS = new TimestampFormat(2);

        private TimestampFormat(byte byTimestampFormat) {
            this.m_byTimestampFormat = byTimestampFormat;
        }

        private byte getValue() {
            return this.m_byTimestampFormat;
        }

        public boolean equals(Object oOther) {
            try {
                TimestampFormat oOtherTF = (TimestampFormat)oOther;
                return this.m_byTimestampFormat == oOtherTF.m_byTimestampFormat;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

