/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class SYLTID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sLanguage = null;
    private TimestampFormat m_oTimestampFormat = null;
    private ContentType m_oContentType = null;
    private String m_sContentDescriptor = null;
    private SortedMap m_oSyncEntryMap = null;

    public SYLTID3V2Frame(String sLanguage, TimestampFormat oTimestampFormat, ContentType oContentType, String sContentDescriptor) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("A three character length language code is required in SYLT frame.");
        }
        this.m_sLanguage = sLanguage;
        if (oTimestampFormat == null) {
            throw new ID3Exception("Timestamp is required for SYLT frame.");
        }
        this.m_oTimestampFormat = oTimestampFormat;
        if (oContentType == null) {
            throw new ID3Exception("Content type is required for SYLT frame.");
        }
        this.m_oContentType = oContentType;
        if (sContentDescriptor == null) {
            throw new ID3Exception("Content descriptor is required for SYLT frame.");
        }
        this.m_sContentDescriptor = sContentDescriptor;
        this.m_oSyncEntryMap = new TreeMap();
    }

    public SYLTID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            byte[] abyLanguage = new byte[3];
            oFrameDataID3DIS.readFully(abyLanguage);
            this.m_sLanguage = new String(abyLanguage);
            this.m_oTimestampFormat = new TimestampFormat((byte)oFrameDataID3DIS.readUnsignedByte());
            this.m_oContentType = new ContentType((byte)oFrameDataID3DIS.readUnsignedByte());
            this.m_sContentDescriptor = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            this.m_oSyncEntryMap = new TreeMap();
            while (oFrameDataID3DIS.available() > 0) {
                String sText = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
                int iTimestamp = oFrameDataID3DIS.readBE32();
                this.m_oSyncEntryMap.put(new Integer(iTimestamp), sText);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitSYLTID3V2Frame(this);
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    public void setLanguage(String sLanguage) throws ID3Exception {
        String sOrigLanguage = this.m_sLanguage;
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("A three character length language code is required in SYLT frame.");
        }
        this.m_sLanguage = sLanguage;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sLanguage = sOrigLanguage;
            throw e;
        }
    }

    public String getLanguage() {
        return this.m_sLanguage;
    }

    public void setTimestampFormat(TimestampFormat oTimestampFormat) {
        this.m_oTimestampFormat = oTimestampFormat;
    }

    public TimestampFormat getTimestampFormat() {
        return this.m_oTimestampFormat;
    }

    public void setContentType(ContentType oContentType) {
        this.m_oContentType = oContentType;
    }

    public ContentType getContentType() {
        return this.m_oContentType;
    }

    public void setContentDescriptor(String sContentDescriptor) throws ID3Exception {
        String sOrigContentDescriptor = this.m_sContentDescriptor;
        if (sContentDescriptor == null) {
            throw new ID3Exception("Content descriptor is required for SYLT frame.");
        }
        this.m_sContentDescriptor = sContentDescriptor;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sContentDescriptor = sOrigContentDescriptor;
            throw e;
        }
    }

    public String getContentDescriptor() {
        return this.m_sContentDescriptor;
    }

    public void addSyncEntry(SyncEntry oSyncEntry) throws ID3Exception {
        if (oSyncEntry == null) {
            throw new ID3Exception("SyncEntry cannot be null.");
        }
        if (this.m_oSyncEntryMap.keySet().contains(new Integer(oSyncEntry.getTimestamp()))) {
            throw new ID3Exception("SYLT frame already contains a sync entry for timestamp " + oSyncEntry.getTimestamp() + ".");
        }
        this.m_oSyncEntryMap.put(new Integer(oSyncEntry.getTimestamp()), oSyncEntry.getText());
    }

    public SyncEntry getSyncEntry(int iTimestamp) {
        if (this.m_oSyncEntryMap.keySet().contains(new Integer(iTimestamp))) {
            try {
                return new SyncEntry((String)this.m_oSyncEntryMap.get(new Integer(iTimestamp)), iTimestamp);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public SyncEntry removeSyncEntry(int iTimestamp) {
        if (this.m_oSyncEntryMap.keySet().contains(new Integer(iTimestamp))) {
            try {
                return new SyncEntry((String)this.m_oSyncEntryMap.remove(new Integer(iTimestamp)), iTimestamp);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public int[] getTimestamps() {
        int[] aiTimestamp = new int[this.m_oSyncEntryMap.keySet().size()];
        int i = 0;
        Iterator oIter = this.m_oSyncEntryMap.keySet().iterator();
        while (oIter.hasNext()) {
            aiTimestamp[i] = (Integer)oIter.next();
            ++i;
        }
        return aiTimestamp;
    }

    protected byte[] getFrameId() {
        return "SYLT".getBytes();
    }

    public String toString() {
        StringBuffer sbText = new StringBuffer();
        sbText.append("Synchronized lyrics/text: Language=[" + this.m_sLanguage + "], Timestamp format=[" + this.m_oTimestampFormat.getValue() + "], Content type=[" + this.m_oContentType.getValue() + "], Content descriptor=[" + this.m_sContentDescriptor + "]");
        Iterator oIter = this.m_oSyncEntryMap.keySet().iterator();
        while (oIter.hasNext()) {
            Integer oTimestamp = (Integer)oIter.next();
            String sText = (String)this.m_oSyncEntryMap.get(oTimestamp);
            sbText.append(" SyncEntry(" + oTimestamp + ", " + sText + ")");
        }
        return sbText.toString();
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sLanguage.getBytes());
        oIDOS.write(this.m_oTimestampFormat.getValue());
        oIDOS.write(this.m_oContentType.getValue());
        oIDOS.write(this.m_sContentDescriptor.getBytes(this.m_oTextEncoding.getEncodingString()));
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        Iterator oIter = this.m_oSyncEntryMap.keySet().iterator();
        while (oIter.hasNext()) {
            Integer oTimestamp = (Integer)oIter.next();
            String sText = (String)this.m_oSyncEntryMap.get(oTimestamp);
            oIDOS.write(sText.getBytes(this.m_oTextEncoding.getEncodingString()));
            if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
                oIDOS.writeUnsignedByte(0);
            } else {
                oIDOS.writeUnsignedByte(0);
                oIDOS.writeUnsignedByte(0);
            }
            oIDOS.writeBE32(oTimestamp);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof SYLTID3V2Frame)) {
            return false;
        }
        SYLTID3V2Frame oOtherSYLT = (SYLTID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherSYLT.m_oTextEncoding) && this.m_sLanguage.equals(oOtherSYLT.m_sLanguage) && this.m_oTimestampFormat.equals(oOtherSYLT.m_oTimestampFormat) && this.m_oContentType.equals(oOtherSYLT.m_oContentType) && this.m_sContentDescriptor.equals(oOtherSYLT.m_sContentDescriptor) && this.m_oSyncEntryMap.equals(oOtherSYLT.m_oSyncEntryMap);
    }

    public static class SyncEntry {
        private String m_sText = null;
        private int m_iTimestamp;

        public SyncEntry(String sText, int iTimestamp) throws ID3Exception {
            if (sText == null) {
                throw new ID3Exception("Text cannot be null in sync entry in SYLT frame.");
            }
            this.m_sText = sText;
            if (iTimestamp < 0) {
                throw new ID3Exception("Timestamp cannot be negative in sync entry in SYLT frame.");
            }
            this.m_iTimestamp = iTimestamp;
        }

        public String getText() {
            return this.m_sText;
        }

        public int getTimestamp() {
            return this.m_iTimestamp;
        }
    }

    public static class ContentType {
        private byte m_byContentType;
        public static final ContentType OTHER = new ContentType(0);
        public static final ContentType LYRICS = new ContentType(1);
        public static final ContentType TEXT_TRANSCRIPTION = new ContentType(2);
        public static final ContentType MOVEMENT = new ContentType(3);
        public static final ContentType EVENTS = new ContentType(4);
        public static final ContentType CHORD = new ContentType(5);
        public static final ContentType TRIVIA = new ContentType(6);

        private ContentType(byte byContentType) {
            this.m_byContentType = byContentType;
        }

        private byte getValue() {
            return this.m_byContentType;
        }

        public boolean equals(Object oOther) {
            try {
                ContentType oOtherCT = (ContentType)oOther;
                return this.m_byContentType == oOtherCT.m_byContentType;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class TimestampFormat {
        private byte m_byTimestampFormat;
        public static final TimestampFormat ABSOLUTE_MPEG_FRAMES = new TimestampFormat(1);
        public static final TimestampFormat ABSOLUTE_MILLISECONDS = new TimestampFormat(2);

        private TimestampFormat(byte byTimestampFormat) {
            this.m_byTimestampFormat = byTimestampFormat;
        }

        private byte getValue() {
            return this.m_byTimestampFormat;
        }

        public boolean equals(Object oOther) {
            try {
                TimestampFormat oOtherTF = (TimestampFormat)oOther;
                return this.m_byTimestampFormat == oOtherTF.m_byTimestampFormat;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

