/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class PRIVID3V2Frame
extends ID3V2Frame {
    private String m_sOwnerIdentifier = null;
    private byte[] m_abyPrivateData = null;

    public PRIVID3V2Frame(String sOwnerIdentifier, byte[] abyPrivateData) throws ID3Exception {
        if (sOwnerIdentifier == null || sOwnerIdentifier.length() == 0) {
            throw new ID3Exception("Owner identifier required in PRIV frame.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        if (abyPrivateData == null) {
            throw new ID3Exception("Private data required in PRIV frame.");
        }
        this.m_abyPrivateData = abyPrivateData;
    }

    public PRIVID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_sOwnerIdentifier = oFrameDataID3DIS.readStringToNull();
            this.m_abyPrivateData = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyPrivateData);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitPRIVID3V2Frame(this);
    }

    public void setPrivateInformation(String sOwnerIdentifier, byte[] abyPrivateData) throws ID3Exception {
        String sOrigOwnerIdentifier = this.m_sOwnerIdentifier;
        byte[] abyOrigPrivateData = this.m_abyPrivateData;
        if (sOwnerIdentifier == null || sOwnerIdentifier.length() == 0) {
            throw new ID3Exception("Owner identifier required in PRIV frame.");
        }
        if (abyPrivateData == null) {
            throw new ID3Exception("Private data required in PRIV frame.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        this.m_abyPrivateData = abyPrivateData;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sOwnerIdentifier = sOrigOwnerIdentifier;
            this.m_abyPrivateData = abyOrigPrivateData;
            throw e;
        }
    }

    public String getOwnerIdentifier() {
        return this.m_sOwnerIdentifier;
    }

    public byte[] getPrivateData() {
        return this.m_abyPrivateData;
    }

    protected byte[] getFrameId() {
        return "PRIV".getBytes();
    }

    public String toString() {
        return "Private information: Ownership identifier=[" + this.m_sOwnerIdentifier + "], Private data length=[" + this.m_abyPrivateData.length + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_sOwnerIdentifier.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.write(this.m_abyPrivateData);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof PRIVID3V2Frame)) {
            return false;
        }
        PRIVID3V2Frame oOtherPRIV = (PRIVID3V2Frame)oOther;
        return this.m_sOwnerIdentifier.equals(oOtherPRIV.m_sOwnerIdentifier) && Arrays.equals(this.m_abyPrivateData, oOtherPRIV.m_abyPrivateData);
    }
}

