/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class MLLTID3V2Frame
extends ID3V2Frame {
    private byte[] m_abyMPEGLocationLookupTable = null;

    public MLLTID3V2Frame(byte[] abyMPEGLocationLookupTable) throws ID3Exception {
        if (abyMPEGLocationLookupTable == null) {
            throw new ID3Exception("MPEG location lookup table cannot be null in MLLT frame.");
        }
        this.m_abyMPEGLocationLookupTable = abyMPEGLocationLookupTable;
    }

    public MLLTID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_abyMPEGLocationLookupTable = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyMPEGLocationLookupTable);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitMLLTID3V2Frame(this);
    }

    public byte[] getMPEGLocationLookupTable() {
        return this.m_abyMPEGLocationLookupTable;
    }

    protected byte[] getFrameId() {
        return "MLLT".getBytes();
    }

    public String toString() {
        return "MPEG location lookup table: length=" + this.m_abyMPEGLocationLookupTable.length;
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_abyMPEGLocationLookupTable);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof MLLTID3V2Frame)) {
            return false;
        }
        MLLTID3V2Frame oOtherMLLT = (MLLTID3V2Frame)oOther;
        return Arrays.equals(this.m_abyMPEGLocationLookupTable, oOtherMLLT.m_abyMPEGLocationLookupTable);
    }
}

