/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class MCDIID3V2Frame
extends ID3V2Frame {
    private byte[] m_abyCDTOC = null;

    public MCDIID3V2Frame(byte[] abyCDTOC) throws ID3Exception {
        this.m_abyCDTOC = abyCDTOC;
        if (abyCDTOC == null || abyCDTOC.length == 0) {
            throw new ID3Exception("MCDI frame requires CD TOC data.");
        }
        if (abyCDTOC.length > 804) {
            throw new ID3Exception("MCDI frame CD TOC data cannot exceed 804 bytes.");
        }
        this.m_abyCDTOC = abyCDTOC;
    }

    public MCDIID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_abyCDTOC = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyCDTOC);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitMCDIID3V2Frame(this);
    }

    public byte[] getCDTOCData() {
        return this.m_abyCDTOC;
    }

    protected byte[] getFrameId() {
        return "MCDI".getBytes();
    }

    public String toString() {
        return "Music CD Identifier: CD TOC length=" + this.m_abyCDTOC.length;
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_abyCDTOC);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof MCDIID3V2Frame)) {
            return false;
        }
        MCDIID3V2Frame oOtherMCDI = (MCDIID3V2Frame)oOther;
        return Arrays.equals(this.m_abyCDTOC, oOtherMCDI.m_abyCDTOC);
    }
}

