/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class COMRID3V2Frame
extends ID3V2Frame {
    public static final byte RECEIVED_AS_OTHER = 0;
    public static final byte RECEIVED_AS_STANDARD_ALBUM = 1;
    public static final byte RECEIVED_AS_COMPRESSED_AUDIO_ON_CD = 2;
    public static final byte RECEIVED_AS_FILE_OVER_THE_INTERNET = 3;
    public static final byte RECEIVED_AS_STREAM_OVER_THE_INTERNET = 4;
    public static final byte RECEIVED_AS_NOTE_SHEETS = 5;
    public static final byte RECEIVED_AS_NOTE_SHEETS_IN_A_BOOK_WITH_OTHER_SHEETS = 6;
    public static final byte RECEIVED_AS_MUSIC_ON_OTHER_MEDIA = 7;
    public static final byte RECEIVED_AS_NON_MUSICAL_MERCHANDISE = 8;
    private TextEncoding m_oTextEncoding;
    private String m_sPrice = null;
    private String m_sValidUntil = null;
    private String m_sContactUrl = null;
    private byte m_byReceivedAs;
    private String m_sNameOfSeller = null;
    private String m_sDescription = null;
    private String m_sPictureMimeType = null;
    private byte[] m_abySellerLogoData = null;

    public COMRID3V2Frame(String sPrice, String sValidUntil, String sContactUrl, byte byReceivedAs, String sNameOfSeller, String sDescription, String sPictureMimeType, byte[] abySellerLogoData) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sPrice == null) {
            throw new ID3Exception("Price required in COMR frame.");
        }
        if (!sPrice.matches("(?uis)(\\w{3}\\d*\\.?\\d+/?)+")) {
            throw new ID3Exception("Invalid COMR frame price string.");
        }
        this.m_sPrice = sPrice;
        if (sValidUntil == null) {
            throw new ID3Exception("Valid until valud required in COMR frame.");
        }
        if (!sValidUntil.matches("(?uis)\\d{8}")) {
            throw new ID3Exception("Invalid COMR frame valid until date.");
        }
        this.m_sValidUntil = sValidUntil;
        if (sContactUrl == null) {
            throw new ID3Exception("Contact URL required in COMR frame.");
        }
        this.m_sContactUrl = sContactUrl;
        this.m_byReceivedAs = byReceivedAs;
        if (sNameOfSeller == null) {
            throw new ID3Exception("Name of seller required in COMR frame.");
        }
        this.m_sNameOfSeller = sNameOfSeller;
        if (sDescription == null) {
            throw new ID3Exception("Description required in COMR frame.");
        }
        this.m_sDescription = sDescription;
        this.m_sPictureMimeType = sPictureMimeType;
        if (this.m_sPictureMimeType == null) {
            this.m_sPictureMimeType = "image/";
        }
        this.m_abySellerLogoData = abySellerLogoData;
    }

    public COMRID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            this.m_sPrice = oFrameDataID3DIS.readStringToNull();
            byte[] abyValidUntil = new byte[8];
            oFrameDataID3DIS.readFully(abyValidUntil);
            this.m_sValidUntil = new String(abyValidUntil);
            this.m_sContactUrl = oFrameDataID3DIS.readStringToNull();
            this.m_byReceivedAs = (byte)oFrameDataID3DIS.readUnsignedByte();
            this.m_sNameOfSeller = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            this.m_sDescription = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            if (oFrameDataID3DIS.available() > 0) {
                this.m_sPictureMimeType = oFrameDataID3DIS.readStringToNull();
                this.m_abySellerLogoData = new byte[oFrameDataID3DIS.available()];
                oFrameDataID3DIS.readFully(this.m_abySellerLogoData);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitCOMRID3V2Frame(this);
    }

    public void setCommercialInformation(String sPrice, String sValidUntil, String sContactUrl, byte byReceivedAs, String sNameOfSeller, String sDescription, String sPictureMimeType, byte[] abySellerLogoData) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sPrice == null) {
            throw new ID3Exception("Price required in COMR frame.");
        }
        if (!sPrice.matches("(?uis)(\\w{3}\\d*\\.?\\d+/?)+")) {
            throw new ID3Exception("Invalid COMR frame price string.");
        }
        this.m_sPrice = sPrice;
        if (sValidUntil == null) {
            throw new ID3Exception("Valid until date required in COMR frame.");
        }
        if (!sValidUntil.matches("(?uis)\\d{8}")) {
            throw new ID3Exception("Invalid COMR frame valid until date.");
        }
        this.m_sValidUntil = sValidUntil;
        if (sContactUrl == null) {
            throw new ID3Exception("Contact URL required in COMR frame.");
        }
        this.m_sContactUrl = sContactUrl;
        this.m_byReceivedAs = byReceivedAs;
        if (sNameOfSeller == null) {
            throw new ID3Exception("Name of seller required in COMR frame.");
        }
        this.m_sNameOfSeller = sNameOfSeller;
        if (sDescription == null) {
            throw new ID3Exception("Description required in COMR frame.");
        }
        this.m_sDescription = sDescription;
        this.m_sPictureMimeType = sPictureMimeType;
        if (this.m_sPictureMimeType == null) {
            this.m_sPictureMimeType = "image/";
        }
        this.m_abySellerLogoData = abySellerLogoData;
    }

    public String getPrice() {
        return this.m_sPrice;
    }

    public String getValidUntilDate() {
        return this.m_sValidUntil;
    }

    public String getContactUrl() {
        return this.m_sContactUrl;
    }

    public byte getReceivedAsFormat() {
        return this.m_byReceivedAs;
    }

    public String getNameOfSeller() {
        return this.m_sNameOfSeller;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public String getSellerLogoMimeType() {
        return this.m_sPictureMimeType;
    }

    public byte[] getSellerLogoData() {
        return this.m_abySellerLogoData;
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected byte[] getFrameId() {
        return "COMR".getBytes();
    }

    public String toString() {
        return "Commercial Frame: Price=[" + this.m_sPrice + "], Valid Until=[" + this.m_sValidUntil + "], Contact URL=[" + this.m_sContactUrl + "], Received As=" + this.m_byReceivedAs + ", Name Of Seller=[" + this.m_sNameOfSeller + "], Description=[" + this.m_sDescription + "], Picture Mime Type=[" + this.m_sPictureMimeType + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sPrice.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.write(this.m_sValidUntil.getBytes());
        oIDOS.write(this.m_sContactUrl.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.writeUnsignedByte(this.m_byReceivedAs);
        if (this.m_sNameOfSeller != null) {
            oIDOS.write(this.m_sNameOfSeller.getBytes(this.m_oTextEncoding.getEncodingString()));
        }
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        if (this.m_sDescription != null) {
            oIDOS.write(this.m_sDescription.getBytes(this.m_oTextEncoding.getEncodingString()));
        }
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        if (this.m_abySellerLogoData != null) {
            if (this.m_sPictureMimeType != null) {
                oIDOS.write(this.m_sPictureMimeType.getBytes());
            }
            oIDOS.writeUnsignedByte(0);
            oIDOS.write(this.m_abySellerLogoData);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof COMRID3V2Frame)) {
            return false;
        }
        COMRID3V2Frame oOtherCOMR = (COMRID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherCOMR.m_oTextEncoding) && this.m_sPrice.equals(oOtherCOMR.m_sPrice) && this.m_sValidUntil.equals(oOtherCOMR.m_sValidUntil) && this.m_sContactUrl.equals(oOtherCOMR.m_sContactUrl) && this.m_byReceivedAs == oOtherCOMR.m_byReceivedAs && this.m_sNameOfSeller.equals(oOtherCOMR.m_sNameOfSeller) && this.m_sDescription.equals(oOtherCOMR.m_sDescription) && this.m_sPictureMimeType.equals(oOtherCOMR.m_sPictureMimeType) && Arrays.equals(this.m_abySellerLogoData, oOtherCOMR.m_abySellerLogoData);
    }
}

