/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v1;

import java.io.InputStream;
import java.io.OutputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.v1.ID3V1_0Tag;
import org.blinkenlights.jid3.v1.ID3V1_1Tag;

public abstract class ID3V1Tag
extends ID3Tag {
    protected String m_sTitle = null;
    protected String m_sArtist = null;
    protected String m_sAlbum = null;
    protected String m_sYear = null;
    protected String m_sComment = null;
    protected Genre m_oGenre = null;

    public void setTitle(String sTitle) {
        if (sTitle.length() > 30) {
            sTitle = sTitle.substring(0, 30);
        }
        this.m_sTitle = sTitle;
    }

    public String getTitle() {
        return this.m_sTitle;
    }

    public void setArtist(String sArtist) {
        if (sArtist.length() > 30) {
            sArtist = sArtist.substring(0, 30);
        }
        this.m_sArtist = sArtist;
    }

    public String getArtist() {
        return this.m_sArtist;
    }

    public void setAlbum(String sAlbum) {
        if (sAlbum.length() > 30) {
            sAlbum = sAlbum.substring(0, 30);
        }
        this.m_sAlbum = sAlbum;
    }

    public String getAlbum() {
        return this.m_sAlbum;
    }

    public void setYear(String sYear) {
        if (sYear.length() > 4) {
            sYear = sYear.substring(0, 4);
        }
        this.m_sYear = sYear;
    }

    public String getYear() {
        return this.m_sYear;
    }

    public abstract void setComment(String var1);

    public String getComment() {
        return this.m_sComment;
    }

    public void setGenre(Genre oGenre) {
        this.m_oGenre = oGenre;
    }

    public Genre getGenre() {
        return this.m_oGenre;
    }

    public static ID3V1Tag read(InputStream oIS) throws ID3Exception {
        try {
            boolean bHasTrackNum;
            String sComment;
            byte[] abyTitle = new byte[30];
            if (oIS.read(abyTitle) != 30) {
                throw new ID3Exception("Unexpected EOF while reading title.");
            }
            String sTitle = new String(abyTitle, 0, ID3V1Tag.indexOfFirstNull(abyTitle));
            byte[] abyArtist = new byte[30];
            if (oIS.read(abyArtist) != 30) {
                throw new ID3Exception("Unexpected EOF while reading artist.");
            }
            String sArtist = new String(abyArtist, 0, ID3V1Tag.indexOfFirstNull(abyArtist));
            byte[] abyAlbum = new byte[30];
            if (oIS.read(abyAlbum) != 30) {
                throw new ID3Exception("Unexpected EOF while reading album.");
            }
            String sAlbum = new String(abyAlbum, 0, ID3V1Tag.indexOfFirstNull(abyAlbum));
            byte[] abyYear = new byte[4];
            if (oIS.read(abyYear) != 4) {
                throw new ID3Exception("Unexpected EOF while reading year.");
            }
            String sYear = new String(abyYear, 0, ID3V1Tag.indexOfFirstNull(abyYear));
            int iTrackNum = -1;
            byte[] abyTemp = new byte[30];
            if (oIS.read(abyTemp) != 30) {
                throw new ID3Exception("Unexpected EOF while reading comment.");
            }
            if (abyTemp[28] == 0 && abyTemp[29] != 0) {
                byte[] abyComment = new byte[29];
                System.arraycopy(abyTemp, 0, abyComment, 0, 29);
                sComment = new String(abyComment, 0, ID3V1Tag.indexOfFirstNull(abyComment));
                iTrackNum = abyTemp[29] & 0xFF;
                bHasTrackNum = true;
            } else {
                sComment = new String(abyTemp, 0, ID3V1Tag.indexOfFirstNull(abyTemp));
                bHasTrackNum = false;
            }
            int iGenre = oIS.read();
            ID3V1Tag oID3V1Tag = null;
            if (bHasTrackNum) {
                oID3V1Tag = new ID3V1_1Tag();
                ((ID3V1_1Tag)oID3V1Tag).setAlbumTrack(iTrackNum);
            } else {
                oID3V1Tag = new ID3V1_0Tag();
            }
            oID3V1Tag.setTitle(sTitle);
            oID3V1Tag.setArtist(sArtist);
            oID3V1Tag.setAlbum(sAlbum);
            oID3V1Tag.setYear(sYear);
            oID3V1Tag.setComment(sComment);
            try {
                oID3V1Tag.setGenre(Genre.lookupGenre(iGenre));
            }
            catch (ID3Exception e) {
                if (ID3Tag.usingStrict()) {
                    throw e;
                }
                oID3V1Tag.setGenre(new Genre((byte)iGenre, "Unknown"));
            }
            return oID3V1Tag;
        }
        catch (Exception e) {
            throw new ID3Exception(e);
        }
    }

    public abstract void write(OutputStream var1) throws ID3Exception;

    public String toString() {
        String sGenre = null;
        try {
            sGenre = Genre.lookupGenre(this.m_oGenre.m_byGenre).toString();
        }
        catch (Exception e) {
            sGenre = Byte.toString(this.m_oGenre.m_byGenre);
        }
        return "SongTitle = [" + this.m_sTitle + "]\n" + "Artist = [" + this.m_sArtist + "]\n" + "Album = [" + this.m_sAlbum + "]\n" + "Year = [" + this.m_sYear + "]\n" + "Comment = [" + this.m_sComment + "]\n" + "Genre = " + sGenre;
    }

    private static int indexOfFirstNull(byte[] abyString) {
        for (int i = 0; i < abyString.length; ++i) {
            if (abyString[i] != 0) continue;
            return i;
        }
        return abyString.length;
    }

    public static class Genre {
        private byte m_byGenre;
        private String m_sGenre;
        public static final Genre Blues = new Genre(0, "Blues");
        public static final Genre ClassicRock = new Genre(1, "Classic Rock");
        public static final Genre Country = new Genre(2, "Country");
        public static final Genre Dance = new Genre(3, "Dance");
        public static final Genre Disco = new Genre(4, "Disco");
        public static final Genre Funk = new Genre(5, "Funk");
        public static final Genre Grunge = new Genre(6, "Grunge");
        public static final Genre HipHop = new Genre(7, "Hip-Hop");
        public static final Genre Jazz = new Genre(8, "Jazz");
        public static final Genre Metal = new Genre(9, "Metal");
        public static final Genre NewAge = new Genre(10, "New Age");
        public static final Genre Oldies = new Genre(11, "Oldies");
        public static final Genre Other = new Genre(12, "Other");
        public static final Genre Pop = new Genre(13, "Pop");
        public static final Genre RhythmBlues = new Genre(14, "R&B");
        public static final Genre Rap = new Genre(15, "Rap");
        public static final Genre Reggae = new Genre(16, "Reggae");
        public static final Genre Rock = new Genre(17, "Rock");
        public static final Genre Techno = new Genre(18, "Techno");
        public static final Genre Industrial = new Genre(19, "Industrial");
        public static final Genre Alternative = new Genre(20, "Alternative");
        public static final Genre Ska = new Genre(21, "Ska");
        public static final Genre DeathMetal = new Genre(22, "Death Metal");
        public static final Genre Pranks = new Genre(23, "Pranks");
        public static final Genre Soundtrack = new Genre(24, "Soundtrack");
        public static final Genre EuroTechno = new Genre(25, "Euro-Techno");
        public static final Genre Ambient = new Genre(26, "Ambient");
        public static final Genre TripHop = new Genre(27, "Trip-Hop");
        public static final Genre Vocal = new Genre(28, "Vocal");
        public static final Genre JazzFunk = new Genre(29, "Jazz-Funk");
        public static final Genre Fusion = new Genre(30, "Fusion");
        public static final Genre Trance = new Genre(31, "Trance");
        public static final Genre Classical = new Genre(32, "Classical");
        public static final Genre Instrumental = new Genre(33, "Instrumental");
        public static final Genre Acid = new Genre(34, "Acid");
        public static final Genre House = new Genre(35, "House");
        public static final Genre Game = new Genre(36, "Game");
        public static final Genre SoundClip = new Genre(37, "Sound Clip");
        public static final Genre Gospel = new Genre(38, "Gospel");
        public static final Genre Noise = new Genre(39, "Noise");
        public static final Genre AlternativeRock = new Genre(40, "Alternative Rock");
        public static final Genre Bass = new Genre(41, "Bass");
        public static final Genre Soul = new Genre(42, "Soul");
        public static final Genre Punk = new Genre(43, "Punk");
        public static final Genre Space = new Genre(44, "Space");
        public static final Genre Meditative = new Genre(45, "Meditative");
        public static final Genre InstrumentalPop = new Genre(46, "Instrumental Pop");
        public static final Genre InstrumentalRock = new Genre(47, "Instrumental Rock");
        public static final Genre Ethnic = new Genre(48, "Ethnic");
        public static final Genre Gothic = new Genre(49, "Gothic");
        public static final Genre DarkWave = new Genre(50, "Dark Wave");
        public static final Genre TechnoIndustrial = new Genre(51, "Techno-Industrial");
        public static final Genre Electronic = new Genre(52, "Electronic");
        public static final Genre PopFolk = new Genre(53, "Pop-Folk");
        public static final Genre EuroDance = new Genre(54, "Euro-Dance");
        public static final Genre Dream = new Genre(55, "Dream");
        public static final Genre SouthernRock = new Genre(56, "Southern Rock");
        public static final Genre Comedy = new Genre(57, "Comedy");
        public static final Genre Cult = new Genre(58, "Cult");
        public static final Genre Gangsta = new Genre(59, "Gangsta");
        public static final Genre Top40 = new Genre(60, "Top 40");
        public static final Genre ChristianRap = new Genre(61, "Christian Rap");
        public static final Genre PopFunk = new Genre(62, "Pop-Funk");
        public static final Genre Jungle = new Genre(63, "Jungle");
        public static final Genre NativeAmerican = new Genre(64, "Native American");
        public static final Genre Cabaret = new Genre(65, "Cabaret");
        public static final Genre NewWave = new Genre(66, "New Wave");
        public static final Genre Psychedelic = new Genre(67, "Psychedelic");
        public static final Genre Rave = new Genre(68, "Rave");
        public static final Genre ShowTunes = new Genre(69, "Show Tunes");
        public static final Genre Trailer = new Genre(70, "Trailer");
        public static final Genre LowFi = new Genre(71, "Low-Fi");
        public static final Genre Tribal = new Genre(72, "Tribal");
        public static final Genre AcidPunk = new Genre(73, "Acid Punk");
        public static final Genre AcidJazz = new Genre(74, "Acid Jazz");
        public static final Genre Polka = new Genre(75, "Polka");
        public static final Genre Retro = new Genre(76, "Retro");
        public static final Genre Musical = new Genre(77, "Musical");
        public static final Genre RockNRoll = new Genre(78, "Rock'N'Roll");
        public static final Genre HardRock = new Genre(79, "Hard Rock");
        public static final Genre EXT_Folk = new Genre(80, "Folk");
        public static final Genre EXT_FolkRock = new Genre(81, "Folk Rock");
        public static final Genre EXT_NationalFolk = new Genre(82, "National Folk");
        public static final Genre EXT_Swing = new Genre(83, "Swing");
        public static final Genre EXT_FastFusion = new Genre(84, "Fast Fusion");
        public static final Genre EXT_Bebop = new Genre(85, "Bebop");
        public static final Genre EXT_Latin = new Genre(86, "Latin");
        public static final Genre EXT_Revival = new Genre(87, "Revival");
        public static final Genre EXT_Celtic = new Genre(88, "Celtic");
        public static final Genre EXT_Bluegrass = new Genre(89, "Bluegrass");
        public static final Genre EXT_AvanteGarde = new Genre(90, "Avante Garde");
        public static final Genre EXT_GothicRock = new Genre(91, "Gothic Rock");
        public static final Genre EXT_ProgressiveRock = new Genre(92, "Progressive Rock");
        public static final Genre EXT_PsychedelicRock = new Genre(93, "Psychedelic Rock");
        public static final Genre EXT_SymphonicRock = new Genre(94, "Symphonic Rock");
        public static final Genre EXT_SlowRock = new Genre(95, "Slow Rock");
        public static final Genre EXT_BigBand = new Genre(96, "Big Band");
        public static final Genre EXT_Chorus = new Genre(97, "Chorus");
        public static final Genre EXT_EasyListening = new Genre(98, "Easy Listening");
        public static final Genre EXT_Acoustic = new Genre(99, "Acoustic");
        public static final Genre EXT_Humour = new Genre(100, "Humour");
        public static final Genre EXT_Speech = new Genre(101, "Speech");
        public static final Genre EXT_Chanson = new Genre(102, "Chanson");
        public static final Genre EXT_Opera = new Genre(103, "Opera");
        public static final Genre EXT_ChamberMusic = new Genre(104, "Chamber Music");
        public static final Genre EXT_Sonata = new Genre(105, "Sonata");
        public static final Genre EXT_Symphony = new Genre(106, "Symphony");
        public static final Genre EXT_BootyBass = new Genre(107, "Booty Bass");
        public static final Genre EXT_Primus = new Genre(108, "Primus");
        public static final Genre EXT_PornGroove = new Genre(109, "Porn Groove");
        public static final Genre EXT_Satire = new Genre(110, "Satire");
        public static final Genre EXT_SlowJam = new Genre(111, "Slow Jam");
        public static final Genre EXT_Club = new Genre(112, "Club");
        public static final Genre EXT_Tango = new Genre(113, "Tango");
        public static final Genre EXT_Samba = new Genre(114, "Samba");
        public static final Genre EXT_Folklore = new Genre(115, "Folklore");
        public static final Genre EXT_Ballad = new Genre(116, "Ballad");
        public static final Genre EXT_PowerBallad = new Genre(117, "Power Ballad");
        public static final Genre EXT_RhythmicSoul = new Genre(118, "Rhythmic Soul");
        public static final Genre EXT_Freestyle = new Genre(119, "Freestyle");
        public static final Genre EXT_Duet = new Genre(120, "Duet");
        public static final Genre EXT_PunkRock = new Genre(121, "Punk Rock");
        public static final Genre EXT_DrumSolo = new Genre(122, "Drum Solo");
        public static final Genre EXT_ACappella = new Genre(123, "A Cappella");
        public static final Genre EXT_EuroHouse = new Genre(124, "Euro-House");
        public static final Genre EXT_DanceHall = new Genre(125, "Dance Hall");
        public static final Genre Nullsoft_Goa = new Genre(126, "Goa");
        public static final Genre Nullsoft_DrumAndBass = new Genre(127, "Drum & Bass");
        public static final Genre Nullsoft_ClubHouse = new Genre(-128, "Club-House");
        public static final Genre Nullsoft_Hardcore = new Genre(-127, "Hardcore");
        public static final Genre Nullsoft_Terror = new Genre(-126, "Terror");
        public static final Genre Nullsoft_Indie = new Genre(-125, "Indie");
        public static final Genre Nullsoft_BritPop = new Genre(-124, "BritPop");
        public static final Genre Nullsoft_Negerpunk = new Genre(-123, "Negerpunk");
        public static final Genre Nullsoft_PolskPunk = new Genre(-122, "Polsk Punk");
        public static final Genre Nullsoft_Beat = new Genre(-121, "Beat");
        public static final Genre Nullsoft_ChristianGangstaRap = new Genre(-120, "Christian Gangsta Rap");
        public static final Genre Nullsoft_HeavyMetal = new Genre(-119, "Heavy Metal");
        public static final Genre Nullsoft_BlackMetal = new Genre(-118, "Black Metal");
        public static final Genre Nullsoft_Crossover = new Genre(-117, "Crossover");
        public static final Genre Nullsoft_ContemporaryChristian = new Genre(-116, "Contemporary Christian");
        public static final Genre Nullsoft_ChristianRock = new Genre(-115, "Christian Rock");
        public static final Genre Nullsoft_Merengue = new Genre(-114, "Merengue");
        public static final Genre Nullsoft_Salsa = new Genre(-113, "Salsa");
        public static final Genre Nullsoft_ThrashMetal = new Genre(-112, "Thrash Metal");
        public static final Genre Nullsoft_Anime = new Genre(-111, "Anime");
        public static final Genre Nullsoft_Jpop = new Genre(-110, "Jpop");
        public static final Genre Nullsoft_Synthpop = new Genre(-109, "Synthpop");
        public static final Genre Undefined = new Genre(-1, "Undefined");
        private static Genre[] s_aoGenre = new Genre[]{Blues, ClassicRock, Country, Dance, Disco, Funk, Grunge, HipHop, Jazz, Metal, NewAge, Oldies, Other, Pop, RhythmBlues, Rap, Reggae, Rock, Techno, Industrial, Alternative, Ska, DeathMetal, Pranks, Soundtrack, EuroTechno, Ambient, TripHop, Vocal, JazzFunk, Fusion, Trance, Classical, Instrumental, Acid, House, Game, SoundClip, Gospel, Noise, AlternativeRock, Bass, Soul, Punk, Space, Meditative, InstrumentalPop, InstrumentalRock, Ethnic, Gothic, DarkWave, TechnoIndustrial, Electronic, PopFolk, EuroDance, Dream, SouthernRock, Comedy, Cult, Gangsta, Top40, ChristianRap, PopFunk, Jungle, NativeAmerican, Cabaret, NewWave, Psychedelic, Rave, ShowTunes, Trailer, LowFi, Tribal, AcidPunk, AcidJazz, Polka, Retro, Musical, RockNRoll, HardRock, EXT_Folk, EXT_FolkRock, EXT_NationalFolk, EXT_Swing, EXT_FastFusion, EXT_Bebop, EXT_Latin, EXT_Revival, EXT_Celtic, EXT_Bluegrass, EXT_AvanteGarde, EXT_GothicRock, EXT_ProgressiveRock, EXT_PsychedelicRock, EXT_SymphonicRock, EXT_SlowRock, EXT_BigBand, EXT_Chorus, EXT_EasyListening, EXT_Acoustic, EXT_Humour, EXT_Speech, EXT_Chanson, EXT_Opera, EXT_ChamberMusic, EXT_Sonata, EXT_Symphony, EXT_BootyBass, EXT_Primus, EXT_PornGroove, EXT_Satire, EXT_SlowJam, EXT_Club, EXT_Tango, EXT_Samba, EXT_Folklore, EXT_Ballad, EXT_PowerBallad, EXT_RhythmicSoul, EXT_Freestyle, EXT_Duet, EXT_PunkRock, EXT_DrumSolo, EXT_ACappella, EXT_EuroHouse, EXT_DanceHall, Nullsoft_Goa, Nullsoft_DrumAndBass, Nullsoft_ClubHouse, Nullsoft_Hardcore, Nullsoft_Terror, Nullsoft_Indie, Nullsoft_BritPop, Nullsoft_Negerpunk, Nullsoft_PolskPunk, Nullsoft_Beat, Nullsoft_ChristianGangstaRap, Nullsoft_HeavyMetal, Nullsoft_BlackMetal, Nullsoft_Crossover, Nullsoft_ContemporaryChristian, Nullsoft_ChristianRock, Nullsoft_Merengue, Nullsoft_Salsa, Nullsoft_ThrashMetal, Nullsoft_Anime, Nullsoft_Jpop, Nullsoft_Synthpop};

        private Genre(byte byGenre, String sGenre) {
            this.m_byGenre = byGenre;
            this.m_sGenre = sGenre;
        }

        public int getByteValue() {
            return this.m_byGenre & 0xFF;
        }

        public boolean equals(Genre oGenre) {
            if (oGenre == null || !(oGenre instanceof Genre)) {
                return false;
            }
            return oGenre.m_byGenre == this.m_byGenre;
        }

        public String toString() {
            return this.m_sGenre;
        }

        public static Genre lookupGenre(int iType) throws ID3Exception {
            try {
                if (iType == 255) {
                    return Undefined;
                }
                return s_aoGenre[iType];
            }
            catch (Exception e) {
                throw new ID3Exception("Invalid V1 genre code " + iType + ".");
            }
        }

        public static Genre lookupGenre(String sGenre) throws ID3Exception {
            for (int i = 0; i < s_aoGenre.length; ++i) {
                if (!Genre.s_aoGenre[i].m_sGenre.equalsIgnoreCase(sGenre)) continue;
                return s_aoGenre[i];
            }
            throw new ID3Exception("Unknown V1 genre [" + sGenre + "].");
        }
    }
}

