/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.MediaFile;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.IFileSource;
import org.blinkenlights.jid3.v1.ID3V1Tag;
import org.blinkenlights.jid3.v2.ID3V2Tag;

public class MP3File
extends MediaFile {
    public MP3File(File oSourceFile) {
        super(oSourceFile);
    }

    public MP3File(IFileSource oFileSource) {
        super(oFileSource);
    }

    public void sync() throws ID3Exception {
        if (this.m_oID3V2Tag != null && !this.m_oID3V2Tag.containsAtLeastOneFrame()) {
            throw new ID3Exception("This file has an ID3 V2 tag which cannot be written because it does not contain at least one frame.");
        }
        if (this.m_oID3V1Tag != null) {
            this.v1Sync();
        }
        if (this.m_oID3V2Tag != null) {
            this.v2Sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void v1Sync() throws ID3Exception {
        IFileSource oTmpFileSource = null;
        BufferedInputStream oSourceIS = null;
        OutputStream oTmpOS = null;
        try {
            try {
                oSourceIS = new BufferedInputStream(this.m_oFileSource.getInputStream());
            }
            catch (Exception e) {
                throw new ID3Exception("Error opening [" + this.m_oFileSource.getName() + "]", e);
            }
            try {
                try {
                    oTmpFileSource = this.m_oFileSource.createTempFile("id3.", ".tmp");
                }
                catch (Exception e) {
                    throw new ID3Exception("Unable to create temporary file.", e);
                }
                try {
                    oTmpOS = oTmpFileSource.getOutputStream();
                }
                catch (Exception e) {
                    throw new ID3Exception("Error opening temporary file for writing.", e);
                }
                try {
                    long lToCopyNow;
                    long lFileLength = this.m_oFileSource.length();
                    byte[] abyBuffer = new byte[65536];
                    long lTotalToCopy = lFileLength - 128L;
                    for (long lCopied = 0L; lCopied < lTotalToCopy; lCopied += lToCopyNow) {
                        long lLeftToCopy = lTotalToCopy - lCopied;
                        lToCopyNow = lLeftToCopy >= 65536L ? 65536L : lLeftToCopy;
                        ((InputStream)oSourceIS).read(abyBuffer, 0, (int)lToCopyNow);
                        oTmpOS.write(abyBuffer, 0, (int)lToCopyNow);
                    }
                    byte[] abyCheckTag = new byte[3];
                    ((InputStream)oSourceIS).read(abyCheckTag);
                    if (abyCheckTag[0] != 84 || abyCheckTag[1] != 65 || abyCheckTag[2] != 71) {
                        oTmpOS.write(abyCheckTag);
                        for (int i = 0; i < 125; ++i) {
                            oTmpOS.write(((InputStream)oSourceIS).read());
                        }
                    }
                    this.m_oID3V1Tag.write(oTmpOS);
                    oTmpOS.flush();
                }
                finally {
                    oTmpOS.close();
                }
            }
            finally {
                ((InputStream)oSourceIS).close();
            }
            if (!this.m_oFileSource.delete()) {
                int iFails = 1;
                int iDelay = 1;
                while (!this.m_oFileSource.delete()) {
                    System.gc();
                    Thread.sleep(iDelay);
                    iDelay *= 2;
                    if (++iFails <= 10) continue;
                    throw new ID3Exception("Unable to delete original file.");
                }
            }
            if (!oTmpFileSource.renameTo(this.m_oFileSource)) {
                throw new ID3Exception("Unable to rename temporary file " + ((Object)oTmpFileSource).toString() + " to " + ((Object)this.m_oFileSource).toString() + ".");
            }
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new ID3Exception("Error processing [" + this.m_oFileSource.getName() + "].", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void v2Sync() throws ID3Exception {
        IFileSource oTmpFileSource = null;
        BufferedInputStream oSourceIS = null;
        BufferedOutputStream oTmpOS = null;
        this.m_oID3V2Tag.sanityCheck();
        try {
            try {
                oSourceIS = new BufferedInputStream(this.m_oFileSource.getInputStream());
            }
            catch (Exception e) {
                throw new ID3Exception("Error opening [" + this.m_oFileSource.getName() + "]", e);
            }
            try {
                try {
                    oTmpFileSource = this.m_oFileSource.createTempFile("id3.", ".tmp");
                }
                catch (Exception e) {
                    throw new ID3Exception("Unable to create temporary file.", e);
                }
                try {
                    oTmpOS = new BufferedOutputStream(oTmpFileSource.getOutputStream());
                }
                catch (Exception e) {
                    throw new ID3Exception("Error opening temporary file for writing.", e);
                }
                try {
                    int iNumRead;
                    this.m_oID3V2Tag.write(oTmpOS);
                    byte[] abyCheckTag = new byte[3];
                    ((InputStream)oSourceIS).read(abyCheckTag);
                    if (abyCheckTag[0] == 73 && abyCheckTag[1] == 68 && abyCheckTag[2] == 51) {
                        long iNumSkipped;
                        int iVersion = ((InputStream)oSourceIS).read();
                        int iPatch = ((InputStream)oSourceIS).read();
                        if (iVersion > 4) {
                            ((OutputStream)oTmpOS).close();
                            oTmpFileSource.delete();
                            throw new ID3Exception("Will not overwrite tag of version greater than 2.4.0.");
                        }
                        ((InputStream)oSourceIS).skip(1L);
                        byte[] abyTagLength = new byte[4];
                        if (((InputStream)oSourceIS).read(abyTagLength) != 4) {
                            throw new ID3Exception("Error reading existing ID3 tag.");
                        }
                        ID3DataInputStream oID3DIS = new ID3DataInputStream(new ByteArrayInputStream(abyTagLength));
                        oID3DIS.close();
                        for (long iTagLength = (long)oID3DIS.readID3Four(); iTagLength > 0L; iTagLength -= iNumSkipped) {
                            iNumSkipped = ((InputStream)oSourceIS).skip(iTagLength);
                            if (iNumSkipped != 0L) continue;
                            throw new ID3Exception("Error reading existing ID3 tag.");
                        }
                    } else {
                        ((OutputStream)oTmpOS).write(abyCheckTag);
                    }
                    byte[] abyBuffer = new byte[65536];
                    while ((iNumRead = ((InputStream)oSourceIS).read(abyBuffer)) != -1) {
                        ((OutputStream)oTmpOS).write(abyBuffer, 0, iNumRead);
                    }
                    ((OutputStream)oTmpOS).flush();
                }
                finally {
                    ((OutputStream)oTmpOS).close();
                }
            }
            finally {
                ((InputStream)oSourceIS).close();
            }
            if (!this.m_oFileSource.delete()) {
                int iFails = 1;
                int iDelay = 1;
                while (!this.m_oFileSource.delete()) {
                    System.gc();
                    Thread.sleep(iDelay);
                    iDelay *= 2;
                    if (++iFails <= 10) continue;
                    throw new ID3Exception("Unable to delete original file.");
                }
            }
            if (!oTmpFileSource.renameTo(this.m_oFileSource)) {
                throw new ID3Exception("Unable to rename temporary file " + ((Object)oTmpFileSource).toString() + " to " + ((Object)this.m_oFileSource).toString() + ".");
            }
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new ID3Exception("Error processing [" + this.m_oFileSource.getName() + "].", e);
        }
    }

    public ID3Tag[] getTags() throws ID3Exception {
        ID3V2Tag oID3V2Tag;
        ArrayList<ID3Tag> oID3TagList = new ArrayList<ID3Tag>();
        ID3V1Tag oID3V1Tag = this.getID3V1Tag();
        if (oID3V1Tag != null) {
            oID3TagList.add(oID3V1Tag);
        }
        if ((oID3V2Tag = this.getID3V2Tag()) != null) {
            oID3TagList.add(oID3V2Tag);
        }
        return oID3TagList.toArray(new ID3Tag[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ID3V1Tag getID3V1Tag() throws ID3Exception {
        try {
            BufferedInputStream oSourceIS = new BufferedInputStream(this.m_oFileSource.getInputStream());
            try {
                long lFileLength = this.m_oFileSource.length();
                ((InputStream)oSourceIS).skip(lFileLength - 128L);
                byte[] abyCheckTag = new byte[3];
                ((InputStream)oSourceIS).read(abyCheckTag);
                if (abyCheckTag[0] == 84 && abyCheckTag[1] == 65 && abyCheckTag[2] == 71) {
                    ID3V1Tag oID3V1Tag;
                    ID3V1Tag iD3V1Tag = oID3V1Tag = ID3V1Tag.read(oSourceIS);
                    return iD3V1Tag;
                }
                ID3V1Tag iD3V1Tag = null;
                return iD3V1Tag;
            }
            finally {
                ((InputStream)oSourceIS).close();
            }
        }
        catch (Exception e) {
            throw new ID3Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ID3V2Tag getID3V2Tag() throws ID3Exception {
        try {
            BufferedInputStream oSourceIS = new BufferedInputStream(this.m_oFileSource.getInputStream());
            ID3DataInputStream oSourceID3DIS = new ID3DataInputStream(oSourceIS);
            try {
                byte[] abyCheckTag = new byte[3];
                oSourceID3DIS.readFully(abyCheckTag);
                if (abyCheckTag[0] == 73 && abyCheckTag[1] == 68 && abyCheckTag[2] == 51) {
                    ID3V2Tag iD3V2Tag = ID3V2Tag.read(oSourceID3DIS);
                    return iD3V2Tag;
                }
                ID3V2Tag iD3V2Tag = null;
                return iD3V2Tag;
            }
            finally {
                oSourceID3DIS.close();
            }
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new ID3Exception("Error reading tags from file.", e);
        }
    }

    public void removeTags() throws ID3Exception {
        this.removeID3V1Tag();
        this.removeID3V2Tag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeID3V1Tag() throws ID3Exception {
        IFileSource oTmpFileSource = null;
        BufferedInputStream oSourceIS = null;
        BufferedOutputStream oTmpOS = null;
        try {
            try {
                oSourceIS = new BufferedInputStream(this.m_oFileSource.getInputStream());
            }
            catch (Exception e) {
                throw new ID3Exception("Error opening [" + this.m_oFileSource.getName() + "]", e);
            }
            try {
                try {
                    oTmpFileSource = this.m_oFileSource.createTempFile("id3.", ".tmp");
                }
                catch (Exception e) {
                    throw new ID3Exception("Unable to create temporary file.", e);
                }
                try {
                    oTmpOS = new BufferedOutputStream(oTmpFileSource.getOutputStream());
                }
                catch (Exception e) {
                    throw new ID3Exception("Error opening temporary file for writing.", e);
                }
                try {
                    long lToCopyNow;
                    long lFileLength = this.m_oFileSource.length();
                    byte[] abyBuffer = new byte[65536];
                    long lTotalToCopy = lFileLength - 128L;
                    for (long lCopied = 0L; lCopied < lTotalToCopy; lCopied += lToCopyNow) {
                        long lLeftToCopy = lTotalToCopy - lCopied;
                        lToCopyNow = lLeftToCopy >= 65536L ? 65536L : lLeftToCopy;
                        ((InputStream)oSourceIS).read(abyBuffer, 0, (int)lToCopyNow);
                        ((OutputStream)oTmpOS).write(abyBuffer, 0, (int)lToCopyNow);
                    }
                    byte[] abyCheckTag = new byte[3];
                    ((InputStream)oSourceIS).read(abyCheckTag);
                    if (abyCheckTag[0] != 84 || abyCheckTag[1] != 65 || abyCheckTag[2] != 71) {
                        ((OutputStream)oTmpOS).write(abyCheckTag);
                        for (int i = 0; i < 125; ++i) {
                            ((OutputStream)oTmpOS).write(((InputStream)oSourceIS).read());
                        }
                    }
                    ((OutputStream)oTmpOS).flush();
                }
                finally {
                    ((OutputStream)oTmpOS).close();
                }
            }
            finally {
                ((InputStream)oSourceIS).close();
            }
            if (!this.m_oFileSource.delete()) {
                int iFails = 1;
                int iDelay = 1;
                while (!this.m_oFileSource.delete()) {
                    System.gc();
                    Thread.sleep(iDelay);
                    iDelay *= 2;
                    if (++iFails <= 10) continue;
                    throw new ID3Exception("Unable to delete original file.");
                }
            }
            if (!oTmpFileSource.renameTo(this.m_oFileSource)) {
                throw new ID3Exception("Unable to rename temporary file " + ((Object)oTmpFileSource).toString() + " to " + ((Object)this.m_oFileSource).toString() + ".");
            }
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new ID3Exception("Error processing [" + this.m_oFileSource.getName() + "].", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeID3V2Tag() throws ID3Exception {
        IFileSource oTmpFileSource = null;
        BufferedInputStream oSourceIS = null;
        BufferedOutputStream oTmpOS = null;
        try {
            oTmpFileSource = this.m_oFileSource.createTempFile("id3.", ".tmp");
        }
        catch (Exception e) {
            throw new ID3Exception("Unable to create temporary file.", e);
        }
        try {
            try {
                oSourceIS = new BufferedInputStream(this.m_oFileSource.getInputStream());
            }
            catch (Exception e) {
                throw new ID3Exception("Error opening [" + this.m_oFileSource.getName() + "]", e);
            }
            try {
                try {
                    oTmpOS = new BufferedOutputStream(oTmpFileSource.getOutputStream());
                }
                catch (Exception e) {
                    throw new ID3Exception("Error opening temporary file for writing.", e);
                }
                try {
                    int iNumRead;
                    byte[] abyCheckTag = new byte[3];
                    ((InputStream)oSourceIS).read(abyCheckTag);
                    if (abyCheckTag[0] == 73 && abyCheckTag[1] == 68 && abyCheckTag[2] == 51) {
                        long iNumSkipped;
                        int iVersion = ((InputStream)oSourceIS).read();
                        int iPatch = ((InputStream)oSourceIS).read();
                        ((InputStream)oSourceIS).skip(1L);
                        byte[] abyTagLength = new byte[4];
                        if (((InputStream)oSourceIS).read(abyTagLength) != 4) {
                            throw new ID3Exception("Error reading existing ID3 tags.");
                        }
                        ID3DataInputStream oID3DIS = new ID3DataInputStream(new ByteArrayInputStream(abyTagLength));
                        oID3DIS.close();
                        for (long iTagLength = (long)oID3DIS.readID3Four(); iTagLength > 0L; iTagLength -= iNumSkipped) {
                            iNumSkipped = ((InputStream)oSourceIS).skip(iTagLength);
                            if (iNumSkipped != 0L) continue;
                            throw new ID3Exception("Error reading existing ID3 tag.");
                        }
                    } else {
                        ((OutputStream)oTmpOS).write(abyCheckTag);
                    }
                    byte[] abyBuffer = new byte[65536];
                    while ((iNumRead = ((InputStream)oSourceIS).read(abyBuffer)) != -1) {
                        ((OutputStream)oTmpOS).write(abyBuffer, 0, iNumRead);
                    }
                    ((OutputStream)oTmpOS).flush();
                }
                finally {
                    ((OutputStream)oTmpOS).close();
                }
            }
            finally {
                ((InputStream)oSourceIS).close();
            }
            if (!this.m_oFileSource.delete()) {
                int iFails = 1;
                int iDelay = 1;
                while (!this.m_oFileSource.delete()) {
                    System.gc();
                    Thread.sleep(iDelay);
                    iDelay *= 2;
                    if (++iFails <= 10) continue;
                    throw new ID3Exception("Unable to delete original file.");
                }
            }
            if (!oTmpFileSource.renameTo(this.m_oFileSource)) {
                throw new ID3Exception("Unable to rename temporary file " + ((Object)oTmpFileSource).toString() + " to " + ((Object)this.m_oFileSource).toString() + ".");
            }
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new ID3Exception("Error processing [" + this.m_oFileSource.getName() + "].", e);
        }
    }
}

