/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UsernameTokenProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(UsernameTokenProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        String id;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found UsernameToken list element");
        }
        if (!"".equals(id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"))) {
            Element foundElement = wsDocInfo.getTokenElement(id);
            if (elem.equals(foundElement)) {
                WSSecurityEngineResult result = wsDocInfo.getResult(id);
                return Collections.singletonList(result);
            }
            if (foundElement != null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "duplicateError", new Object[0]);
            }
        }
        Validator validator = data.getValidator(WSSecurityEngine.USERNAME_TOKEN);
        Credential credential = this.handleUsernameToken(elem, validator, data);
        UsernameToken token = credential.getUsernametoken();
        int action = 1;
        byte[] secretKey = null;
        if (token.getPassword() == null) {
            action = 8192;
            if (token.isDerivedKey()) {
                token.setRawPassword(data);
                secretKey = token.getDerivedKey(data.getBSPEnforcer());
            }
        }
        WSSecurityEngineResult result = new WSSecurityEngineResult(action, token);
        result.put("id", token.getID());
        result.put("secret", secretKey);
        if (validator != null) {
            result.put("validated-token", Boolean.TRUE);
            if (credential.getTransformedToken() != null) {
                result.put("transformed-token", credential.getTransformedToken());
                if (credential.getPrincipal() != null) {
                    result.put("principal", credential.getPrincipal());
                } else {
                    SAMLTokenPrincipalImpl samlPrincipal = new SAMLTokenPrincipalImpl(credential.getTransformedToken());
                    result.put("principal", samlPrincipal);
                }
            } else if (credential.getPrincipal() != null) {
                result.put("principal", credential.getPrincipal());
            } else {
                WSUsernameTokenPrincipalImpl principal = new WSUsernameTokenPrincipalImpl(token.getName(), token.isHashed());
                principal.setNonce(Base64.decodeBase64((String)token.getNonce()));
                principal.setPassword(token.getPassword());
                principal.setCreatedTime(token.getCreated());
                principal.setPasswordType(token.getPasswordType());
                result.put("principal", principal);
            }
            result.put("subject", credential.getSubject());
        }
        wsDocInfo.addTokenElement(elem);
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    private Credential handleUsernameToken(Element token, Validator validator, RequestData data) throws WSSecurityException {
        boolean allowNamespaceQualifiedPasswordTypes = false;
        WSSConfig wssConfig = data.getWssConfig();
        int utTTL = 300;
        int futureTimeToLive = 60;
        if (wssConfig != null) {
            allowNamespaceQualifiedPasswordTypes = wssConfig.getAllowNamespaceQualifiedPasswordTypes();
            utTTL = wssConfig.getUtTTL();
            futureTimeToLive = wssConfig.getUtFutureTTL();
        }
        UsernameToken ut = new UsernameToken(token, allowNamespaceQualifiedPasswordTypes, data.getBSPEnforcer());
        ReplayCache replayCache = data.getNonceReplayCache();
        if (replayCache != null && ut.getNonce() != null) {
            if (replayCache.contains(ut.getNonce())) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "badUsernameToken", new Object[]{"A replay attack has been detected"});
            }
            Date created = ut.getCreatedDate();
            if (created == null || utTTL <= 0) {
                replayCache.add(ut.getNonce());
            } else {
                replayCache.add(ut.getNonce(), (long)utTTL + 1L);
            }
        }
        if (!ut.verifyCreated(utTTL, futureTimeToLive)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.MESSAGE_EXPIRED);
        }
        Credential credential = new Credential();
        credential.setUsernametoken(ut);
        if (validator != null) {
            return validator.validate(credential, data);
        }
        return credential;
    }
}

