/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

public class UsernameTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$UsernameTokenProcessor == null ? (class$org$apache$ws$security$processor$UsernameTokenProcessor = UsernameTokenProcessor.class$("org.apache.ws.security.processor.UsernameTokenProcessor")) : class$org$apache$ws$security$processor$UsernameTokenProcessor).getName());
    private String utId;
    static /* synthetic */ Class class$org$apache$ws$security$processor$UsernameTokenProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found UsernameToken list element");
        }
        WSUsernameTokenPrincipal lastPrincipalFound = this.handleUsernameToken(elem, cb);
        returnResults.add(0, new WSSecurityEngineResult(1, lastPrincipalFound, null, null, null));
        this.utId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public WSUsernameTokenPrincipal handleUsernameToken(Element token, CallbackHandler cb) throws WSSecurityException {
        WSPasswordCallback pwCb;
        UsernameToken ut = new UsernameToken(token);
        String user = ut.getName();
        String password = ut.getPassword();
        String nonce = ut.getNonce();
        String createdTime = ut.getCreated();
        String pwType = ut.getPasswordType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("UsernameToken user " + user));
            log.debug((Object)("UsernameToken password " + password));
        }
        Callback[] callbacks = new Callback[1];
        if (ut.isHashed()) {
            String passDigest;
            if (cb == null) {
                throw new WSSecurityException(0, "noCallback");
            }
            pwCb = new WSPasswordCallback(user, 2);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user}, e);
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user}, e);
            }
            String origPassword = pwCb.getPassword();
            if (log.isDebugEnabled()) {
                log.debug((Object)("UsernameToken callback password " + origPassword));
            }
            if (origPassword == null) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
            if (nonce != null && createdTime != null && !(passDigest = UsernameToken.doPasswordDigest(nonce, createdTime, origPassword)).equals(password)) {
                throw new WSSecurityException(5);
            }
        } else if (cb != null) {
            pwCb = new WSPasswordCallback(user, password, pwType, 5);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
        }
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(user, ut.isHashed());
        principal.setNonce(nonce);
        principal.setPassword(password);
        principal.setCreatedTime(createdTime);
        principal.setPasswordType(pwType);
        return principal;
    }

    public String getId() {
        return this.utId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

