/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.listener;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.util.collections.ReverseListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListenerCollection<T>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ListenerCollection.class);
    private final List<T> listeners = new CopyOnWriteArrayList<T>();

    public boolean add(T listener) {
        if (listener == null && !this.isAllowingNulls()) {
            return false;
        }
        if (!this.isAllowingDuplicates() && this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    protected void notify(INotifier<T> notifier) {
        for (T listener : this.listeners) {
            notifier.notify(listener);
        }
    }

    protected void notifyIgnoringExceptions(INotifier<T> notifier) {
        for (T listener : this.listeners) {
            try {
                notifier.notify(listener);
            }
            catch (Exception e) {
                logger.error("Error invoking listener: " + listener, (Throwable)e);
            }
        }
    }

    protected void reversedNotifyIgnoringExceptions(final INotifier<T> notifier) {
        this.reversedNotify(new INotifier<T>(){

            @Override
            public void notify(T listener) {
                try {
                    notifier.notify(listener);
                }
                catch (Exception e) {
                    logger.error("Error invoking listener: " + listener, (Throwable)e);
                }
            }
        });
    }

    protected void reversedNotify(INotifier<T> notifier) {
        ReverseListIterator<T> it = new ReverseListIterator<T>(this.listeners);
        while (it.hasNext()) {
            notifier.notify(it.next());
        }
    }

    public void remove(T listener) {
        this.listeners.remove(listener);
    }

    protected boolean isAllowingDuplicates() {
        return true;
    }

    protected boolean isAllowingNulls() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listeners.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface INotifier<T> {
        public void notify(T var1);
    }
}

