/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;

@DefaultKey(value="cookies")
@ValidScope(value={"request"})
public class CookieTool {
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    public void setRequest(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request should not be null");
        }
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        if (response == null) {
            throw new NullPointerException("response should not be null");
        }
        this.response = response;
    }

    public Cookie[] getAll() {
        return this.request.getCookies();
    }

    public Cookie get(String name) {
        Cookie[] all = this.getAll();
        if (all == null) {
            return null;
        }
        for (int i = 0; i < all.length; ++i) {
            Cookie cookie = all[i];
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public void add(String name, String value) {
        this.response.addCookie(this.create(name, value));
    }

    public void add(String name, String value, Object maxAge) {
        Cookie c = this.create(name, value, maxAge);
        if (c == null) {
            return;
        }
        this.response.addCookie(c);
    }

    public Cookie create(String name, String value) {
        return new Cookie(name, value);
    }

    public Cookie create(String name, String value, Object maxAge) {
        int expiry;
        if (maxAge instanceof Number) {
            expiry = ((Number)maxAge).intValue();
        } else {
            try {
                expiry = Integer.parseInt(String.valueOf(maxAge));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        Cookie c = new Cookie(name, value);
        c.setMaxAge(expiry);
        return c;
    }
}

