/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.deploy.FileChangeListener;
import org.apache.catalina.ha.deploy.FileMessage;
import org.apache.catalina.ha.deploy.FileMessageFactory;
import org.apache.catalina.ha.deploy.UndeployMessage;
import org.apache.catalina.ha.deploy.WarWatcher;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.util.ContextName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class FarmWarDeployer
extends ClusterListener
implements ClusterDeployer,
FileChangeListener {
    private static final Log log = LogFactory.getLog(FarmWarDeployer.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.deploy");
    private static final String info = "FarmWarDeployer/1.2";
    protected boolean started = false;
    protected HashMap<String, FileMessageFactory> fileFactories = new HashMap();
    protected String deployDir;
    private File deployDirFile = null;
    protected String tempDir;
    private File tempDirFile = null;
    protected String watchDir;
    private File watchDirFile = null;
    protected boolean watchEnabled = false;
    protected WarWatcher watcher = null;
    private int count = 0;
    protected int processDeployFrequency = 2;
    protected File configBase = null;
    protected Host host = null;
    protected File appBase = null;
    protected MBeanServer mBeanServer = null;
    protected ObjectName oname = null;

    public String getInfo() {
        return info;
    }

    @Override
    public void start() throws Exception {
        if (this.started) {
            return;
        }
        Container hcontainer = this.getCluster().getContainer();
        if (!(hcontainer instanceof Host)) {
            log.error((Object)sm.getString("farmWarDeployer.hostOnly"));
            return;
        }
        this.host = (Host)hcontainer;
        Container econtainer = this.host.getParent();
        if (!(econtainer instanceof Engine)) {
            log.error((Object)sm.getString("farmWarDeployer.hostParentEngine", new Object[]{this.host.getName()}));
            return;
        }
        Engine engine = (Engine)econtainer;
        String hostname = null;
        hostname = this.host.getName();
        try {
            this.oname = new ObjectName(engine.getName() + ":type=Deployer,host=" + hostname);
        }
        catch (Exception e) {
            log.error((Object)sm.getString("farmWarDeployer.mbeanNameFail", new Object[]{engine.getName(), hostname}), (Throwable)e);
            return;
        }
        if (this.watchEnabled) {
            this.watcher = new WarWatcher(this, this.getWatchDirFile());
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("farmWarDeployer.watchDir", new Object[]{this.getWatchDir()}));
            }
        }
        if (this.host.getXmlBase() != null) {
            this.configBase = this.getAbsolutePath(this.host.getXmlBase());
        } else {
            StringBuilder xmlDir = new StringBuilder("conf");
            xmlDir.append('/');
            xmlDir.append(engine.getName());
            xmlDir.append('/');
            xmlDir.append(this.host.getName());
            this.configBase = this.getAbsolutePath(xmlDir.toString());
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        this.started = true;
        this.count = 0;
        this.getCluster().addClusterListener(this);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("farmWarDeployer.started"));
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        this.count = 0;
        if (this.watcher != null) {
            this.watcher.clear();
            this.watcher = null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("farmWarDeployer.stopped"));
        }
    }

    public void cleanDeployDir() {
        throw new UnsupportedOperationException(sm.getString("farmWarDeployer.notImplemented", new Object[]{"cleanDeployDir()"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ClusterMessage msg) {
        block24: {
            try {
                if (msg instanceof FileMessage) {
                    FileMessageFactory factory;
                    FileMessage fmsg = (FileMessage)msg;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("farmWarDeployer.msgRxDeploy", new Object[]{fmsg.getContextName(), fmsg.getFileName()}));
                    }
                    if (!(factory = this.getFactory(fmsg)).writeMessage(fmsg)) break block24;
                    String name = factory.getFile().getName();
                    if (!name.endsWith(".war")) {
                        name = name + ".war";
                    }
                    File deployable = new File(this.getDeployDirFile(), name);
                    try {
                        String contextName = fmsg.getContextName();
                        if (!this.isServiced(contextName)) {
                            this.addServiced(contextName);
                            try {
                                this.remove(contextName);
                                if (!factory.getFile().renameTo(deployable)) {
                                    log.error((Object)sm.getString("farmWarDeployer.renameFail", new Object[]{factory.getFile(), deployable}));
                                }
                                this.check(contextName);
                            }
                            finally {
                                this.removeServiced(contextName);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)sm.getString("farmWarDeployer.deployEnd", new Object[]{contextName}));
                            }
                            break block24;
                        }
                        log.error((Object)sm.getString("farmWarDeployer.servicingDeploy", new Object[]{contextName, name}));
                        break block24;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        break block24;
                    }
                    finally {
                        this.removeFactory(fmsg);
                    }
                }
                if (!(msg instanceof UndeployMessage)) break block24;
                try {
                    UndeployMessage umsg = (UndeployMessage)msg;
                    String contextName = umsg.getContextName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("farmWarDeployer.msgRxUndeploy", new Object[]{contextName}));
                    }
                    if (!this.isServiced(contextName)) {
                        this.addServiced(contextName);
                        try {
                            this.remove(contextName);
                        }
                        finally {
                            this.removeServiced(contextName);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("farmWarDeployer.undeployEnd", new Object[]{contextName}));
                        }
                        break block24;
                    }
                    log.error((Object)sm.getString("farmWarDeployer.servicingUneploy", new Object[]{contextName}));
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
            catch (IOException x) {
                log.error((Object)sm.getString("farmWarDeployer.msgIoe"), (Throwable)x);
            }
        }
    }

    public synchronized FileMessageFactory getFactory(FileMessage msg) throws FileNotFoundException, IOException {
        File writeToFile = new File(this.getTempDirFile(), msg.getFileName());
        FileMessageFactory factory = this.fileFactories.get(msg.getFileName());
        if (factory == null) {
            factory = FileMessageFactory.getInstance(writeToFile, true);
            this.fileFactories.put(msg.getFileName(), factory);
        }
        return factory;
    }

    public void removeFactory(FileMessage msg) {
        this.fileFactories.remove(msg.getFileName());
    }

    @Override
    public boolean accept(ClusterMessage msg) {
        return msg instanceof FileMessage || msg instanceof UndeployMessage;
    }

    @Override
    public void install(String contextName, File webapp) throws IOException {
        Member[] members = this.getCluster().getMembers();
        if (members.length == 0) {
            return;
        }
        Member localMember = this.getCluster().getLocalMember();
        FileMessageFactory factory = FileMessageFactory.getInstance(webapp, false);
        FileMessage msg = new FileMessage(localMember, webapp.getName(), contextName);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("farmWarDeployer.sendStart", new Object[]{contextName, webapp}));
        }
        msg = factory.readMessage(msg);
        while (msg != null) {
            for (int i = 0; i < members.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("farmWarDeployer.sendFragment", new Object[]{contextName, webapp, members[i]}));
                }
                this.getCluster().send(msg, members[i]);
            }
            msg = factory.readMessage(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("farmWarDeployer.sendEnd", new Object[]{contextName, webapp}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String contextName, boolean undeploy) throws IOException {
        block10: {
            if (this.getCluster().getMembers().length > 0) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("farmWarDeployer.removeStart", new Object[]{contextName}));
                }
                Member localMember = this.getCluster().getLocalMember();
                UndeployMessage msg = new UndeployMessage(localMember, System.currentTimeMillis(), "Undeploy:" + contextName + ":" + System.currentTimeMillis(), contextName, undeploy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("farmWarDeployer.removeTxMsg", new Object[]{contextName}));
                }
                this.cluster.send(msg);
            }
            if (undeploy) {
                try {
                    if (!this.isServiced(contextName)) {
                        this.addServiced(contextName);
                        try {
                            this.remove(contextName);
                            break block10;
                        }
                        finally {
                            this.removeServiced(contextName);
                        }
                    }
                    log.error((Object)sm.getString("farmWarDeployer.removeFailRemote", new Object[]{contextName}));
                }
                catch (Exception ex) {
                    log.error((Object)sm.getString("farmWarDeployer.removeFailLocal", new Object[]{contextName}), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileModified(File newWar) {
        try {
            File deployWar = new File(this.getDeployDirFile(), newWar.getName());
            ContextName cn = new ContextName(deployWar.getName());
            if (deployWar.exists() && deployWar.lastModified() > newWar.lastModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("farmWarDeployer.alreadyDeployed", new Object[]{cn.getName()}));
                }
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("farmWarDeployer.modInstall", new Object[]{cn.getName(), deployWar.getAbsolutePath()}));
            }
            if (!this.isServiced(cn.getName())) {
                this.addServiced(cn.getName());
                try {
                    this.copy(newWar, deployWar);
                    this.check(cn.getName());
                }
                finally {
                    this.removeServiced(cn.getName());
                }
            } else {
                log.error((Object)sm.getString("farmWarDeployer.servicingDeploy", new Object[]{cn.getName(), deployWar.getName()}));
            }
            this.install(cn.getName(), deployWar);
        }
        catch (Exception x) {
            log.error((Object)sm.getString("farmWarDeployer.modInstallFail"), (Throwable)x);
        }
    }

    @Override
    public void fileRemoved(File removeWar) {
        try {
            ContextName cn = new ContextName(removeWar.getName());
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("farmWarDeployer.removeLocal", new Object[]{cn.getName()}));
            }
            this.remove(cn.getName(), true);
        }
        catch (Exception x) {
            log.error((Object)sm.getString("farmWarDeployer.removeLocalFail"), (Throwable)x);
        }
    }

    protected File getAppBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected void remove(String contextName) throws Exception {
        Context context = (Context)this.host.findChild(contextName);
        if (context != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("farmWarDeployer.undeployLocal", new Object[]{contextName}));
            }
            context.stop();
            String baseName = context.getBaseName();
            File war = new File(this.getAppBase(), baseName + ".war");
            File dir = new File(this.getAppBase(), baseName);
            File xml = new File(this.configBase, baseName + ".xml");
            if (war.exists()) {
                if (!war.delete()) {
                    log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{war}));
                }
            } else if (dir.exists()) {
                this.undeployDir(dir);
            } else if (!xml.delete()) {
                log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{xml}));
            }
            this.check(contextName);
        }
    }

    protected void undeployDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.undeployDir(file);
                continue;
            }
            if (file.delete()) continue;
            log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{file}));
        }
        if (!dir.delete()) {
            log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{dir}));
        }
    }

    @Override
    public void backgroundProcess() {
        if (this.started && this.watchEnabled) {
            this.count = (this.count + 1) % this.processDeployFrequency;
            if (this.count == 0) {
                this.watcher.check();
            }
        }
    }

    protected void check(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", params, signature);
    }

    protected boolean isServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", params, signature);
        return result;
    }

    protected void addServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", params, signature);
    }

    protected void removeServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", params, signature);
    }

    @Override
    public boolean equals(Object listener) {
        return super.equals(listener);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public File getDeployDirFile() {
        File dir;
        if (this.deployDirFile != null) {
            return this.deployDirFile;
        }
        this.deployDirFile = dir = this.getAbsolutePath(this.getDeployDir());
        return dir;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public File getTempDirFile() {
        File dir;
        if (this.tempDirFile != null) {
            return this.tempDirFile;
        }
        this.tempDirFile = dir = this.getAbsolutePath(this.getTempDir());
        return dir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getWatchDir() {
        return this.watchDir;
    }

    public File getWatchDirFile() {
        File dir;
        if (this.watchDirFile != null) {
            return this.watchDirFile;
        }
        this.watchDirFile = dir = this.getAbsolutePath(this.getWatchDir());
        return dir;
    }

    public void setWatchDir(String watchDir) {
        this.watchDir = watchDir;
    }

    public boolean isWatchEnabled() {
        return this.watchEnabled;
    }

    public boolean getWatchEnabled() {
        return this.watchEnabled;
    }

    public void setWatchEnabled(boolean watchEnabled) {
        this.watchEnabled = watchEnabled;
    }

    public int getProcessDeployFrequency() {
        return this.processDeployFrequency;
    }

    public void setProcessDeployFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        this.processDeployFrequency = processExpiresFrequency;
    }

    protected boolean copy(File from, File to) {
        try {
            int len;
            if (!to.exists() && !to.createNewFile()) {
                log.error((Object)sm.getString("fileNewFail", new Object[]{to}));
                return false;
            }
            FileInputStream is = new FileInputStream(from);
            FileOutputStream os = new FileOutputStream(to, false);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            log.error((Object)sm.getString("farmWarDeployer.fileCopyFail", new Object[]{from, to}), (Throwable)e);
            return false;
        }
        return true;
    }

    private File getAbsolutePath(String path) {
        File dir = new File(path);
        File base = new File(System.getProperty("catalina.base"));
        if (!dir.isAbsolute()) {
            dir = new File(base, dir.getPath());
        }
        try {
            dir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        return dir;
    }
}

