/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.request.Request;
import org.apache.tiles.template.NoSuchAttributeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAttributeModel {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(String name, String scope, String toName, boolean ignore, Request request) {
        Map<String, Object> attributes = this.getImportedAttributes(name, toName, ignore, request);
        if (scope == null) {
            scope = (String)request.getAvailableScopes().get(0);
        }
        request.getContext(scope).putAll(attributes);
    }

    private Map<String, Object> getImportedAttributes(String name, String toName, boolean ignore, Request request) {
        TilesContainer container = TilesAccess.getCurrentContainer((Request)request);
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        AttributeContext attributeContext = container.getAttributeContext(request);
        if (name != null) {
            this.importSingleAttribute(container, attributeContext, name, toName, ignore, retValue, request);
        } else {
            this.importAttributes(attributeContext.getCascadedAttributeNames(), container, attributeContext, retValue, ignore, request);
            this.importAttributes(attributeContext.getLocalAttributeNames(), container, attributeContext, retValue, ignore, request);
        }
        return retValue;
    }

    private void importSingleAttribute(TilesContainer container, AttributeContext attributeContext, String name, String toName, boolean ignore, Map<String, Object> attributes, Request request) {
        block9: {
            Attribute attr = attributeContext.getAttribute(name);
            if (attr != null) {
                try {
                    Object attributeValue = container.evaluate(attr, request);
                    if (attributeValue == null) {
                        if (!ignore) {
                            throw new NoSuchAttributeException("Error importing attributes. Attribute '" + name + "' has a null value ");
                        }
                        break block9;
                    }
                    if (toName != null) {
                        attributes.put(toName, attributeValue);
                        break block9;
                    }
                    attributes.put(name, attributeValue);
                }
                catch (RuntimeException e) {
                    if (!ignore) {
                        throw e;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Ignoring Tiles Exception", (Throwable)e);
                    }
                    break block9;
                }
            }
            if (!ignore) {
                throw new NoSuchAttributeException("Error importing attributes. Attribute '" + name + "' is null");
            }
        }
    }

    private void importAttributes(Collection<String> names, TilesContainer container, AttributeContext attributeContext, Map<String, Object> attributes, boolean ignore, Request request) {
        if (names == null || names.isEmpty()) {
            return;
        }
        for (String name : names) {
            if (name == null && !ignore) {
                throw new NoSuchAttributeException("Error importing attributes. Attribute with null key found.");
            }
            if (name == null) continue;
            this.importSingleAttribute(container, attributeContext, name, name, ignore, attributes, request);
        }
    }
}

