/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.compat.definition.digester;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.tiles.Attribute;
import org.apache.tiles.beans.SimpleMenuItem;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.xml.sax.Attributes;

public class CompatibilityDigesterDefinitionsReader
extends DigesterDefinitionsReader {
    private static final String ADD_WILDCARD = "*/item";
    private static final String BEAN_TAG = "*/bean";
    protected String[] registrations;

    protected void initSyntax(Digester digester) {
        super.initSyntax(digester);
        this.initDigesterForComponentsDefinitionsSyntax(digester);
        this.initDigesterForInstancesSyntax(digester);
        this.initDigesterForTilesDefinitionsSyntax(digester);
        this.initDigesterForBeans(digester);
    }

    private void initDigesterForComponentsDefinitionsSyntax(Digester digester) {
        String definitionTag = "component-definitions/definition";
        String putTag = definitionTag + "/put";
        String listTag = definitionTag + "/putList";
        String addListElementTag = listTag + "/add";
        digester.addObjectCreate(definitionTag, DEFINITION_HANDLER_CLASS);
        digester.addRule(definitionTag, (Rule)new DigesterDefinitionsReader.FillDefinitionRule());
        digester.addSetNext(definitionTag, "addDefinition", DEFINITION_HANDLER_CLASS);
        digester.addObjectCreate(putTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(listTag, LIST_HANDLER_CLASS);
        digester.addSetProperties(listTag);
        digester.addRule(listTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(addListElementTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(addListElementTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addSetNext(addListElementTag, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        String definitionTag = "tiles-definitions/definition";
        String putTag = definitionTag + "/put";
        String listTag = "putList";
        String definitionListTag = definitionTag + "/" + listTag;
        String addListElementTag = "*/" + listTag + "/add";
        digester.addObjectCreate(putTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(definitionListTag, LIST_HANDLER_CLASS);
        digester.addSetProperties(definitionListTag);
        digester.addRule(definitionListTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(addListElementTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(addListElementTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addSetNext(addListElementTag, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        String nestedList = "*/" + listTag + "/" + listTag;
        digester.addObjectCreate(nestedList, LIST_HANDLER_CLASS);
        digester.addSetProperties(nestedList);
        digester.addSetNext(nestedList, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
    }

    private void initDigesterForInstancesSyntax(Digester digester) {
        String instanceTag = "component-instances/instance";
        String putTag = instanceTag + "/put";
        String putAttributeTag = instanceTag + "/putAttribute";
        String listTag = instanceTag + "/putList";
        String addListElementTag = listTag + "/add";
        digester.addObjectCreate(instanceTag, DEFINITION_HANDLER_CLASS);
        digester.addRule(instanceTag, (Rule)new DigesterDefinitionsReader.FillDefinitionRule());
        digester.addSetNext(instanceTag, "addDefinition", DEFINITION_HANDLER_CLASS);
        digester.addObjectCreate(putAttributeTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(putTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addSetProperties(putTag);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(listTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addSetProperties(listTag);
        digester.addRule(listTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(addListElementTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(addListElementTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addSetNext(addListElementTag, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
    }

    private void initDigesterForBeans(Digester digester) {
        String menuItemDefaultClass = SimpleMenuItem.class.getName();
        digester.addObjectCreate(ADD_WILDCARD, menuItemDefaultClass, "classtype");
        digester.addSetProperties(ADD_WILDCARD);
        digester.addRule(ADD_WILDCARD, (Rule)new SetValueToAttributeRule());
        digester.addSetNext(ADD_WILDCARD, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        String beanDefaultClass = SimpleMenuItem.class.getName();
        digester.addObjectCreate(BEAN_TAG, beanDefaultClass, "classtype");
        digester.addSetProperties(BEAN_TAG);
        digester.addRule(BEAN_TAG, (Rule)new SetValueToAttributeRule());
        digester.addSetNext(BEAN_TAG, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addSetProperty("*/bean/set-property", "property", "value");
    }

    protected String[] getRegistrations() {
        if (this.registrations == null) {
            this.registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration 3.0//EN", "/org/apache/tiles/resources/tiles-config_3_0.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 2.0//EN", "/org/apache/tiles/compat/resources/tiles-config_2_0.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 2.1//EN", "/org/apache/tiles/compat/resources/tiles-config_2_1.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 1.1//EN", "/org/apache/tiles/compat/resources/tiles-config_1_1.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 1.3//EN", "/org/apache/tiles/compat/resources/tiles-config_1_3.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 1.4//EN", "/org/apache/tiles/compat/resources/tiles-config_1_4.dtd"};
        }
        return this.registrations;
    }

    public static class SetValueToAttributeRule
    extends Rule {
        public void begin(String namespace, String name, Attributes attributes) {
            Object obj = this.digester.pop();
            Attribute attribute = new Attribute(obj);
            this.digester.push((Object)attribute);
        }
    }
}

