/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HttpSolrClient
extends SolrClient {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String DEFAULT_PATH = "/select";
    private static final long serialVersionUID = -946812319974801896L;
    public static final String AGENT = "Solr[" + HttpSolrClient.class.getName() + "] 1.0";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected volatile String baseUrl;
    protected ModifiableSolrParams invariantParams;
    protected volatile ResponseParser parser;
    protected volatile RequestWriter requestWriter = new RequestWriter();
    private final HttpClient httpClient;
    private volatile boolean followRedirects = false;
    private volatile boolean useMultiPartPost;
    private final boolean internalClient;
    private volatile Set<String> queryParams = Collections.emptySet();

    public HttpSolrClient(String baseURL) {
        this(baseURL, null, new BinaryResponseParser());
    }

    public HttpSolrClient(String baseURL, HttpClient client) {
        this(baseURL, client, new BinaryResponseParser());
    }

    public HttpSolrClient(String baseURL, HttpClient client, ResponseParser parser) {
        this.baseUrl = baseURL;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.baseUrl.indexOf(63) >= 0) {
            throw new RuntimeException("Invalid base url for solrj.  The base URL must not contain parameters: " + this.baseUrl);
        }
        if (client != null) {
            this.httpClient = client;
            this.internalClient = false;
        } else {
            this.internalClient = true;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("maxConnections", 128);
            params.set("maxConnectionsPerHost", 32);
            params.set("followRedirects", this.followRedirects);
            this.httpClient = HttpClientUtil.createClient(params);
        }
        this.parser = parser;
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.request(request, responseParser, collection);
    }

    public NamedList<Object> request(SolrRequest request, ResponseParser processor) throws SolrServerException, IOException {
        return this.request(request, processor, null);
    }

    public NamedList<Object> request(SolrRequest request, ResponseParser processor, String collection) throws SolrServerException, IOException {
        HttpRequestBase method = this.createMethod(request, collection);
        this.setBasicAuthHeader(request, method);
        return this.executeMethod(method, processor);
    }

    private void setBasicAuthHeader(SolrRequest request, HttpRequestBase method) throws UnsupportedEncodingException {
        if (request.getBasicAuthUser() != null && request.getBasicAuthPassword() != null) {
            String userPass = request.getBasicAuthUser() + ":" + request.getBasicAuthPassword();
            String encoded = Base64.byteArrayToBase64(userPass.getBytes(UTF_8));
            method.setHeader((Header)new BasicHeader("Authorization", "Basic " + encoded));
        }
    }

    public HttpUriRequestResponse httpUriRequest(SolrRequest request) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.httpUriRequest(request, responseParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpUriRequestResponse httpUriRequest(SolrRequest request, final ResponseParser processor) throws SolrServerException, IOException {
        HttpUriRequestResponse mrr = new HttpUriRequestResponse();
        final HttpRequestBase method = this.createMethod(request, null);
        ExecutorService pool = ExecutorUtil.newMDCAwareFixedThreadPool(1, new SolrjNamedThreadFactory("httpUriRequest"));
        try {
            MDC.put((String)"HttpSolrClient.url", (String)this.baseUrl);
            mrr.future = pool.submit(new Callable<NamedList<Object>>(){

                @Override
                public NamedList<Object> call() throws Exception {
                    return HttpSolrClient.this.executeMethod(method, processor);
                }
            });
        }
        finally {
            pool.shutdown();
            MDC.remove((String)"HttpSolrClient.url");
        }
        assert (method != null);
        mrr.httpUriRequest = method;
        return mrr;
    }

    protected ModifiableSolrParams calculateQueryParams(Set<String> queryParamNames, ModifiableSolrParams wparams) {
        ModifiableSolrParams queryModParams = new ModifiableSolrParams();
        if (queryParamNames != null) {
            for (String param : queryParamNames) {
                String[] value = wparams.getParams(param);
                if (value == null) continue;
                for (String v : value) {
                    queryModParams.add(param, v);
                }
                wparams.remove(param);
            }
        }
        return queryModParams;
    }

    protected HttpRequestBase createMethod(SolrRequest request, String collection) throws IOException, SolrServerException {
        ResponseParser parser;
        SolrParams params = request.getParams();
        Collection<ContentStream> streams = this.requestWriter.getContentStreams(request);
        String path = this.requestWriter.getPath(request);
        if (path == null || !path.startsWith("/")) {
            path = DEFAULT_PATH;
        }
        if ((parser = request.getResponseParser()) == null) {
            parser = this.parser;
        }
        ModifiableSolrParams wparams = new ModifiableSolrParams(params);
        if (parser != null) {
            wparams.set("wt", parser.getWriterType());
            wparams.set("version", parser.getVersion());
        }
        if (this.invariantParams != null) {
            wparams.add(this.invariantParams);
        }
        String basePath = this.baseUrl;
        if (collection != null) {
            basePath = basePath + "/" + collection;
        }
        if (SolrRequest.METHOD.GET == request.getMethod()) {
            if (streams != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
            }
            return new HttpGet(basePath + path + wparams.toQueryString());
        }
        if (SolrRequest.METHOD.POST == request.getMethod() || SolrRequest.METHOD.PUT == request.getMethod()) {
            String url = basePath + path;
            boolean hasNullStreamName = false;
            if (streams != null) {
                for (ContentStream cs : streams) {
                    if (cs.getName() != null) continue;
                    hasNullStreamName = true;
                    break;
                }
            }
            boolean isMultipart = (this.useMultiPartPost && SolrRequest.METHOD.POST == request.getMethod() || streams != null && streams.size() > 1) && !hasNullStreamName;
            LinkedList<BasicNameValuePair> postOrPutParams = new LinkedList<BasicNameValuePair>();
            if (streams == null || isMultipart) {
                HttpPost postOrPut;
                ModifiableSolrParams queryParams = this.calculateQueryParams(this.queryParams, wparams);
                queryParams.add(this.calculateQueryParams(request.getQueryParams(), wparams));
                String fullQueryUrl = url + queryParams.toQueryString();
                Object object = postOrPut = SolrRequest.METHOD.POST == request.getMethod() ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
                if (!isMultipart) {
                    postOrPut.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                }
                LinkedList<FormBodyPart> parts = new LinkedList<FormBodyPart>();
                Iterator<String> iter = wparams.getParameterNamesIterator();
                while (iter.hasNext()) {
                    String p = iter.next();
                    String[] vals = wparams.getParams(p);
                    if (vals == null) continue;
                    for (String v : vals) {
                        if (isMultipart) {
                            parts.add(new FormBodyPart(p, (ContentBody)new StringBody(v, StandardCharsets.UTF_8)));
                            continue;
                        }
                        postOrPutParams.add(new BasicNameValuePair(p, v));
                    }
                }
                if (isMultipart && streams != null) {
                    for (ContentStream content : streams) {
                        String name;
                        String contentType = content.getContentType();
                        if (contentType == null) {
                            contentType = "application/octet-stream";
                        }
                        if ((name = content.getName()) == null) {
                            name = "";
                        }
                        parts.add(new FormBodyPart(name, (ContentBody)new InputStreamBody(content.getStream(), contentType, content.getName())));
                    }
                }
                if (parts.size() > 0) {
                    MultipartEntity entity = new MultipartEntity(HttpMultipartMode.STRICT);
                    for (FormBodyPart p : parts) {
                        entity.addPart(p);
                    }
                    postOrPut.setEntity((HttpEntity)entity);
                } else {
                    postOrPut.setEntity((HttpEntity)new UrlEncodedFormEntity(postOrPutParams, StandardCharsets.UTF_8));
                }
                return postOrPut;
            }
            String fullQueryUrl = url + wparams.toQueryString();
            HttpPost postOrPut = SolrRequest.METHOD.POST == request.getMethod() ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
            final ContentStream[] contentStream = new ContentStream[1];
            Iterator<ContentStream> i$ = streams.iterator();
            if (i$.hasNext()) {
                ContentStream content;
                contentStream[0] = content = i$.next();
            }
            if (contentStream[0] instanceof RequestWriter.LazyContentStream) {
                postOrPut.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), -1L){

                    public Header getContentType() {
                        return new BasicHeader("Content-Type", contentStream[0].getContentType());
                    }

                    public boolean isRepeatable() {
                        return false;
                    }
                });
            } else {
                postOrPut.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), -1L){

                    public Header getContentType() {
                        return new BasicHeader("Content-Type", contentStream[0].getContentType());
                    }

                    public boolean isRepeatable() {
                        return false;
                    }
                });
            }
            return postOrPut;
        }
        throw new SolrServerException("Unsupported method: " + (Object)((Object)request.getMethod()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NamedList<Object> executeMethod(HttpRequestBase method, ResponseParser processor) throws SolrServerException {
        method.addHeader("User-Agent", AGENT);
        InputStream respBody = null;
        boolean shouldClose = true;
        boolean success = false;
        try {
            String mimeType;
            String procMimeType;
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
            int httpStatus = response.getStatusLine().getStatusCode();
            respBody = response.getEntity().getContent();
            Header ctHeader = response.getLastHeader("content-type");
            String contentType = ctHeader != null ? ctHeader.getValue() : "";
            switch (httpStatus) {
                case 200: 
                case 400: 
                case 409: {
                    break;
                }
                case 301: 
                case 302: {
                    if (this.followRedirects) break;
                    throw new SolrServerException("Server at " + this.getBaseURL() + " sent back a redirect (" + httpStatus + ").");
                }
                default: {
                    if (processor == null) throw new RemoteSolrException(this.baseUrl, httpStatus, "non ok status: " + httpStatus + ", message:" + response.getStatusLine().getReasonPhrase(), null);
                    if (!"".equals(contentType)) break;
                    throw new RemoteSolrException(this.baseUrl, httpStatus, "non ok status: " + httpStatus + ", message:" + response.getStatusLine().getReasonPhrase(), null);
                }
            }
            if (processor == null || processor instanceof InputStreamResponseParser) {
                NamedList<Object> rsp = new NamedList<Object>();
                rsp.add("stream", respBody);
                shouldClose = false;
                success = true;
                NamedList<Object> namedList = rsp;
                return namedList;
            }
            String procCt = processor.getContentType();
            if (procCt != null && !(procMimeType = ContentType.parse((String)procCt).getMimeType().trim().toLowerCase(Locale.ROOT)).equals(mimeType = ContentType.parse((String)contentType).getMimeType().trim().toLowerCase(Locale.ROOT))) {
                String msg = "Expected mime type " + procMimeType + " but got " + mimeType + ".";
                Header encodingHeader = response.getEntity().getContentEncoding();
                String encoding = encodingHeader != null ? encodingHeader.getValue() : "UTF-8";
                try {
                    msg = msg + " " + IOUtils.toString((InputStream)respBody, (String)encoding);
                    throw new RemoteSolrException(this.baseUrl, httpStatus, msg, null);
                }
                catch (IOException e) {
                    throw new RemoteSolrException(this.baseUrl, httpStatus, "Could not parse response with encoding " + encoding, e);
                }
            }
            NamedList<Object> rsp = null;
            String charset = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
            try {
                rsp = processor.processResponse(respBody, charset);
            }
            catch (Exception e) {
                throw new RemoteSolrException(this.baseUrl, httpStatus, e.getMessage(), e);
            }
            if (httpStatus != 200) {
                NamedList metadata = null;
                String reason = null;
                try {
                    NamedList err = (NamedList)rsp.get("error");
                    if (err != null) {
                        reason = (String)err.get("msg");
                        if (reason == null) {
                            reason = (String)err.get("trace");
                        }
                        metadata = (NamedList)err.get("metadata");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (reason == null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(response.getStatusLine().getReasonPhrase()).append("\n\n").append("request: ").append(method.getURI());
                    reason = URLDecoder.decode(msg.toString(), UTF_8);
                }
                RemoteSolrException rss = new RemoteSolrException(this.baseUrl, httpStatus, reason, null);
                if (metadata == null) throw rss;
                rss.setMetadata(metadata);
                throw rss;
            }
            success = true;
            NamedList<Object> namedList = rsp;
            return namedList;
        }
        catch (ConnectException e) {
            throw new SolrServerException("Server refused connection at: " + this.getBaseURL(), e);
        }
        catch (SocketTimeoutException e) {
            throw new SolrServerException("Timeout occured while waiting response from server at: " + this.getBaseURL(), e);
        }
        catch (IOException e) {
            throw new SolrServerException("IOException occured when talking to server at: " + this.getBaseURL(), e);
        }
        finally {
            if (respBody != null && shouldClose) {
                try {
                    respBody.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
                finally {
                    if (!success) {
                        method.abort();
                    }
                }
            }
        }
    }

    public ModifiableSolrParams getInvariantParams() {
        return this.invariantParams;
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(String baseURL) {
        this.baseUrl = baseURL;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser processor) {
        this.parser = processor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectionTimeout(int timeout) {
        HttpClientUtil.setConnectionTimeout(this.httpClient, timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpClientUtil.setSoTimeout(this.httpClient, timeout);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        HttpClientUtil.setFollowRedirects(this.httpClient, followRedirects);
    }

    public void setAllowCompression(boolean allowCompression) {
        if (!(this.httpClient instanceof DefaultHttpClient)) {
            throw new UnsupportedOperationException("HttpClient instance was not of type DefaultHttpClient");
        }
        HttpClientUtil.setAllowCompression((DefaultHttpClient)this.httpClient, allowCompression);
    }

    public void setMaxRetries(int maxRetries) {
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null && this.internalClient) {
            HttpClientUtil.close(this.httpClient);
        }
    }

    @Override
    @Deprecated
    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDefaultMaxConnectionsPerHost(int max) {
        if (!this.internalClient) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        HttpClientUtil.setMaxConnectionsPerHost(this.httpClient, max);
    }

    public void setMaxTotalConnections(int max) {
        if (!this.internalClient) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        HttpClientUtil.setMaxConnections(this.httpClient, max);
    }

    public boolean isUseMultiPartPost() {
        return this.useMultiPartPost;
    }

    public void setUseMultiPartPost(boolean useMultiPartPost) {
        this.useMultiPartPost = useMultiPartPost;
    }

    public static class RemoteSolrException
    extends SolrException {
        public RemoteSolrException(String remoteHost, int code, String msg, Throwable th) {
            super(code, "Error from server at " + remoteHost + ": " + msg, th);
        }
    }

    public static class HttpUriRequestResponse {
        public HttpUriRequest httpUriRequest;
        public Future<NamedList<Object>> future;
    }
}

