/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.driver.jdbc.adapter.invocation.MethodInvocationRecorder;
import org.apache.shardingsphere.driver.jdbc.core.ShardingSphereSavepoint;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.kernel.connection.OverallConnectionNotEnoughException;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.OnlineDatabaseConnectionManager;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.metadata.proxy.ProxyInstanceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.metadata.persist.MetaDataBasedPersistService;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.traffic.rule.TrafficRule;
import org.apache.shardingsphere.transaction.ConnectionSavepointManager;
import org.apache.shardingsphere.transaction.ConnectionTransaction;
import org.apache.shardingsphere.transaction.rule.TransactionRule;

public final class DriverDatabaseConnectionManager
implements OnlineDatabaseConnectionManager<Connection>,
AutoCloseable {
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private final Map<String, DataSource> physicalDataSourceMap = new LinkedHashMap<String, DataSource>();
    private final Map<String, DataSource> trafficDataSourceMap = new LinkedHashMap<String, DataSource>();
    private final ConnectionTransaction connectionTransaction;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final MethodInvocationRecorder<Connection> methodInvocationRecorder = new MethodInvocationRecorder();
    private final ForceExecuteTemplate<Connection> forceExecuteTemplate = new ForceExecuteTemplate();
    private final Random random = new SecureRandom();
    private final ConnectionContext connectionContext;
    private final ContextManager contextManager;
    private final String databaseName;

    public DriverDatabaseConnectionManager(String databaseName, ContextManager contextManager) {
        for (Map.Entry entry : contextManager.getStorageUnits(databaseName).entrySet()) {
            DataSource dataSource = ((StorageUnit)entry.getValue()).getDataSource();
            String cacheKey = this.getKey(databaseName, (String)entry.getKey());
            this.dataSourceMap.put(cacheKey, dataSource);
            this.physicalDataSourceMap.put(cacheKey, dataSource);
        }
        for (Map.Entry<Object, Object> entry : this.getTrafficDataSourceMap(databaseName, contextManager).entrySet()) {
            String cacheKey = this.getKey(databaseName, (String)entry.getKey());
            this.dataSourceMap.put(cacheKey, (DataSource)entry.getValue());
            this.trafficDataSourceMap.put(cacheKey, (DataSource)entry.getValue());
        }
        this.connectionTransaction = this.createConnectionTransaction(contextManager);
        this.connectionContext = new ConnectionContext(() -> this.cachedConnections.keySet());
        this.connectionContext.setCurrentDatabase(databaseName);
        this.contextManager = contextManager;
        this.databaseName = databaseName;
    }

    private Map<String, DataSource> getTrafficDataSourceMap(String databaseName, ContextManager contextManager) {
        TrafficRule rule = (TrafficRule)contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TrafficRule.class);
        if (rule.getStrategyRules().isEmpty()) {
            return Collections.emptyMap();
        }
        MetaDataBasedPersistService persistService = contextManager.getMetaDataContexts().getPersistService();
        String actualDatabaseName = contextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getName();
        Map propsMap = (Map)persistService.getDataSourceUnitService().load(actualDatabaseName);
        Preconditions.checkState((!propsMap.isEmpty() ? 1 : 0) != 0, (Object)"Can not get data source properties from meta data.");
        DataSourcePoolProperties propsSample = (DataSourcePoolProperties)propsMap.values().iterator().next();
        Collection users = ((AuthorityRule)contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class)).getConfiguration().getUsers();
        Collection<InstanceMetaData> instances = contextManager.getInstanceContext().getAllClusterInstances(InstanceType.PROXY, rule.getLabels()).values();
        return DataSourcePoolCreator.create(this.createDataSourcePoolPropertiesMap(instances, users, propsSample, actualDatabaseName), (boolean)true);
    }

    private Map<String, DataSourcePoolProperties> createDataSourcePoolPropertiesMap(Collection<InstanceMetaData> instances, Collection<ShardingSphereUser> users, DataSourcePoolProperties propsSample, String schema) {
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>();
        for (InstanceMetaData each : instances) {
            result.put(each.getId(), this.createDataSourcePoolProperties((ProxyInstanceMetaData)each, users, propsSample, schema));
        }
        return result;
    }

    private DataSourcePoolProperties createDataSourcePoolProperties(ProxyInstanceMetaData instanceMetaData, Collection<ShardingSphereUser> users, DataSourcePoolProperties propsSample, String schema) {
        Map props = propsSample.getAllLocalProperties();
        props.put("jdbcUrl", this.createJdbcUrl(instanceMetaData, schema, props));
        ShardingSphereUser user = users.iterator().next();
        props.put("username", user.getGrantee().getUsername());
        props.put("password", user.getPassword());
        return new DataSourcePoolProperties("com.zaxxer.hikari.HikariDataSource", props);
    }

    private String createJdbcUrl(ProxyInstanceMetaData instanceMetaData, String schema, Map<String, Object> props) {
        String jdbcUrl = String.valueOf(props.get("jdbcUrl"));
        String jdbcUrlPrefix = jdbcUrl.substring(0, jdbcUrl.indexOf("//"));
        String jdbcUrlSuffix = jdbcUrl.contains("?") ? jdbcUrl.substring(jdbcUrl.indexOf(63)) : "";
        return String.format("%s//%s:%s/%s%s", jdbcUrlPrefix, instanceMetaData.getIp(), instanceMetaData.getPort(), schema, jdbcUrlSuffix);
    }

    private ConnectionTransaction createConnectionTransaction(ContextManager contextManager) {
        TransactionRule rule = (TransactionRule)contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class);
        return new ConnectionTransaction(rule);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.methodInvocationRecorder.record("setAutoCommit", target -> target.setAutoCommit(autoCommit));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setAutoCommit(autoCommit));
    }

    public void commit() throws SQLException {
        try {
            if (this.connectionTransaction.isLocalTransaction() && this.connectionTransaction.isRollbackOnly()) {
                this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::rollback);
            } else if (this.connectionTransaction.isLocalTransaction()) {
                this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::commit);
            } else {
                this.connectionTransaction.commit();
            }
        }
        finally {
            for (Connection each : this.cachedConnections.values()) {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
        }
    }

    public void rollback() throws SQLException {
        try {
            if (this.connectionTransaction.isLocalTransaction()) {
                this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::rollback);
            } else {
                this.connectionTransaction.rollback();
            }
        }
        finally {
            for (Connection each : this.cachedConnections.values()) {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().rollbackToSavepoint(each, savepoint.getSavepointName());
        }
    }

    public Savepoint setSavepoint(String savepointName) throws SQLException {
        ShardingSphereSavepoint result = new ShardingSphereSavepoint(savepointName);
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, savepointName);
        }
        this.methodInvocationRecorder.record("setSavepoint", target -> ConnectionSavepointManager.getInstance().setSavepoint(target, savepointName));
        return result;
    }

    public Savepoint setSavepoint() throws SQLException {
        ShardingSphereSavepoint result = new ShardingSphereSavepoint();
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, result.getSavepointName());
        }
        this.methodInvocationRecorder.record("setSavepoint", target -> ConnectionSavepointManager.getInstance().setSavepoint(target, result.getSavepointName()));
        return result;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().releaseSavepoint(each, savepoint.getSavepointName());
        }
    }

    public Optional<Integer> getTransactionIsolation() throws SQLException {
        return this.cachedConnections.values().isEmpty() ? Optional.empty() : Optional.of(((Connection)this.cachedConnections.values().iterator().next()).getTransactionIsolation());
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.methodInvocationRecorder.record("setTransactionIsolation", connection -> connection.setTransactionIsolation(level));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setTransactionIsolation(level));
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.methodInvocationRecorder.record("setReadOnly", connection -> connection.setReadOnly(readOnly));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setReadOnly(readOnly));
    }

    public boolean isValid(int timeout) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            if (each.isValid(timeout)) continue;
            return false;
        }
        return true;
    }

    public String getRandomPhysicalDataSourceName() {
        return this.getRandomPhysicalDatabaseAndDataSourceName()[1];
    }

    private String[] getRandomPhysicalDatabaseAndDataSourceName() {
        Sets.SetView cachedPhysicalDataSourceNames = Sets.intersection(this.physicalDataSourceMap.keySet(), (Set)this.cachedConnections.keySet());
        Sets.SetView databaseAndDatasourceNames = cachedPhysicalDataSourceNames.isEmpty() ? this.physicalDataSourceMap.keySet() : cachedPhysicalDataSourceNames;
        return ((String)new ArrayList(databaseAndDatasourceNames).get(this.random.nextInt(databaseAndDatasourceNames.size()))).split("\\.");
    }

    public Connection getRandomConnection() throws SQLException {
        String[] databaseAndDataSourceName = this.getRandomPhysicalDatabaseAndDataSourceName();
        return this.getConnections(databaseAndDataSourceName[0], databaseAndDataSourceName[1], 0, 1, ConnectionMode.MEMORY_STRICTLY).get(0);
    }

    public List<Connection> getConnections(String dataSourceName, int connectionOffset, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        return this.getConnections(this.connectionContext.getDatabaseName().orElse(this.databaseName), dataSourceName, connectionOffset, connectionSize, connectionMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> getConnections(String currentDatabaseName, String dataSourceName, int connectionOffset, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        String cacheKey = this.getKey(currentDatabaseName, dataSourceName);
        DataSource dataSource = this.databaseName.equals(currentDatabaseName) ? this.dataSourceMap.get(cacheKey) : ((StorageUnit)this.contextManager.getStorageUnits(currentDatabaseName).get(dataSourceName)).getDataSource();
        Preconditions.checkNotNull((Object)dataSource, (String)"Missing the data source name: '%s'", (Object)dataSourceName);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)cacheKey);
        }
        int maxConnectionSize = connectionOffset + connectionSize;
        if (connections.size() >= maxConnectionSize) {
            result = new ArrayList(connections).subList(connectionOffset, maxConnectionSize);
        } else {
            if (connections.isEmpty()) {
                List<Connection> newConnections = this.createConnections(currentDatabaseName, dataSourceName, dataSource, maxConnectionSize, connectionMode);
                result = new ArrayList<Connection>(newConnections).subList(connectionOffset, maxConnectionSize);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)cacheKey, newConnections);
                }
            }
            ArrayList<Connection> allConnections = new ArrayList<Connection>(maxConnectionSize);
            allConnections.addAll(connections);
            List<Connection> newConnections = this.createConnections(currentDatabaseName, dataSourceName, dataSource, maxConnectionSize - connections.size(), connectionMode);
            allConnections.addAll(newConnections);
            result = allConnections.subList(connectionOffset, maxConnectionSize);
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)cacheKey, newConnections);
            }
        }
        return result;
    }

    private String getKey(String databaseName, String dataSourceName) {
        return databaseName.toLowerCase() + "." + dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> createConnections(String databaseName, String dataSourceName, DataSource dataSource, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        if (1 == connectionSize) {
            Connection connection = this.createConnection(databaseName, dataSourceName, dataSource, this.connectionContext.getTransactionContext());
            this.methodInvocationRecorder.replay(connection);
            return Collections.singletonList(connection);
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(databaseName, dataSourceName, dataSource, connectionSize, this.connectionContext.getTransactionContext());
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(databaseName, dataSourceName, dataSource, connectionSize, this.connectionContext.getTransactionContext());
        }
    }

    private List<Connection> createConnections(String databaseName, String dataSourceName, DataSource dataSource, int connectionSize, TransactionConnectionContext transactionConnectionContext) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                Connection connection = this.createConnection(databaseName, dataSourceName, dataSource, transactionConnectionContext);
                this.methodInvocationRecorder.replay(connection);
                result.add(connection);
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new OverallConnectionNotEnoughException(connectionSize, result.size(), (Exception)ex).toSQLException();
            }
        }
        return result;
    }

    private Connection createConnection(String databaseName, String dataSourceName, DataSource dataSource, TransactionConnectionContext transactionConnectionContext) throws SQLException {
        Optional connectionInTransaction = this.isRawJdbcDataSource(databaseName, dataSourceName) ? this.connectionTransaction.getConnection(databaseName, dataSourceName, transactionConnectionContext) : Optional.empty();
        return connectionInTransaction.isPresent() ? (Connection)connectionInTransaction.get() : dataSource.getConnection();
    }

    private boolean isRawJdbcDataSource(String databaseName, String dataSourceName) {
        return !this.trafficDataSourceMap.containsKey(this.getKey(databaseName, dataSourceName));
    }

    @Override
    public void close() throws SQLException {
        try {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::close);
        }
        finally {
            this.cachedConnections.clear();
        }
    }

    @Generated
    public ConnectionTransaction getConnectionTransaction() {
        return this.connectionTransaction;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

