/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverJDBCExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;
import org.apache.shardingsphere.traffic.executor.TrafficExecutor;

public final class DriverExecutor
implements AutoCloseable {
    private final DriverJDBCExecutor regularExecutor;
    private final RawExecutor rawExecutor;
    private final SQLFederationEngine sqlFederationEngine;
    private final TrafficExecutor trafficExecutor;

    public DriverExecutor(ShardingSphereConnection connection) {
        MetaDataContexts metaDataContexts = connection.getContextManager().getMetaDataContexts();
        ExecutorEngine executorEngine = connection.getContextManager().getExecutorEngine();
        JDBCExecutor jdbcExecutor = new JDBCExecutor(executorEngine, connection.getDatabaseConnectionManager().getConnectionContext());
        this.regularExecutor = new DriverJDBCExecutor(connection.getDatabaseName(), connection.getContextManager(), jdbcExecutor);
        this.rawExecutor = new RawExecutor(executorEngine, connection.getDatabaseConnectionManager().getConnectionContext());
        ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(connection.getDatabaseName());
        String schemaName = new DatabaseTypeRegistry(database.getProtocolType()).getDefaultSchemaName(connection.getDatabaseName());
        this.sqlFederationEngine = new SQLFederationEngine(connection.getDatabaseName(), schemaName, metaDataContexts.getMetaData(), metaDataContexts.getStatistics(), jdbcExecutor);
        this.trafficExecutor = new TrafficExecutor();
    }

    @Override
    public void close() throws SQLException {
        this.sqlFederationEngine.close();
        this.trafficExecutor.close();
    }

    @Generated
    public DriverJDBCExecutor getRegularExecutor() {
        return this.regularExecutor;
    }

    @Generated
    public RawExecutor getRawExecutor() {
        return this.rawExecutor;
    }

    @Generated
    public SQLFederationEngine getSqlFederationEngine() {
        return this.sqlFederationEngine;
    }

    @Generated
    public TrafficExecutor getTrafficExecutor() {
        return this.trafficExecutor;
    }
}

