/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.state.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.state.datasource.DataSourceState;
import org.apache.shardingsphere.infra.state.datasource.exception.UnavailableDataSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceStateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceStateManager.class);
    private static final DataSourceStateManager INSTANCE = new DataSourceStateManager();
    private final Map<String, DataSourceState> dataSourceStates = new ConcurrentHashMap<String, DataSourceState>();
    private volatile boolean forceStart;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public static DataSourceStateManager getInstance() {
        return INSTANCE;
    }

    public void initStates(String databaseName, Map<String, StorageUnit> storageUnits, Map<String, DataSourceState> storageDataSourceStates, boolean forceStart) {
        this.forceStart = forceStart;
        if (this.initialized.compareAndSet(false, true)) {
            storageUnits.forEach((key, value) -> this.initState(databaseName, storageDataSourceStates, (String)key, value.getDataSource()));
        }
    }

    private void initState(String databaseName, Map<String, DataSourceState> storageDataSourceStates, String actualDataSourceName, DataSource dataSource) {
        DataSourceState storageState = storageDataSourceStates.get(this.getCacheKey(databaseName, actualDataSourceName));
        if (DataSourceState.DISABLED == storageState) {
            this.dataSourceStates.put(this.getCacheKey(databaseName, actualDataSourceName), storageState);
        } else {
            this.checkState(databaseName, actualDataSourceName, dataSource);
        }
    }

    private void checkState(String databaseName, String actualDataSourceName, DataSource dataSource) {
        try (Connection ignored = dataSource.getConnection();){
            this.dataSourceStates.put(this.getCacheKey(databaseName, actualDataSourceName), DataSourceState.ENABLED);
        }
        catch (SQLException ex) {
            ShardingSpherePreconditions.checkState((boolean)this.forceStart, () -> new UnavailableDataSourceException(actualDataSourceName, ex));
            log.error("Data source unavailable, ignored with the -f parameter.", (Throwable)ex);
        }
    }

    public Map<String, DataSource> getEnabledDataSources(String databaseName, DatabaseConfiguration databaseConfig) {
        Map dataSources = databaseConfig.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return this.getEnabledDataSources(databaseName, dataSources);
    }

    public Map<String, DataSource> getEnabledDataSources(String databaseName, Map<String, DataSource> dataSources) {
        if (dataSources.isEmpty() || !this.initialized.get()) {
            return dataSources;
        }
        Map<String, DataSource> result = this.filterDisabledDataSources(databaseName, dataSources);
        this.checkForceConnection(result);
        return result;
    }

    private Map<String, DataSource> filterDisabledDataSources(String databaseName, Map<String, DataSource> dataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSources.size(), 1.0f);
        dataSources.forEach((key, value) -> {
            DataSourceState dataSourceState = this.dataSourceStates.get(this.getCacheKey(databaseName, (String)key));
            if (DataSourceState.DISABLED != dataSourceState) {
                result.put((String)key, (DataSource)value);
            }
        });
        return result;
    }

    private void checkForceConnection(Map<String, DataSource> dataSources) {
        if (this.forceStart) {
            dataSources.entrySet().removeIf(entry -> {
                boolean bl;
                block8: {
                    Connection ignored = ((DataSource)entry.getValue()).getConnection();
                    try {
                        bl = false;
                        if (ignored == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException ex) {
                            log.error("Data source state unavailable, ignored with the -f parameter.", (Throwable)ex);
                            return true;
                        }
                    }
                    ignored.close();
                }
                return bl;
            });
        }
    }

    public void updateState(String databaseName, String actualDataSourceName, DataSourceState dataSourceState) {
        this.dataSourceStates.put(this.getCacheKey(databaseName, actualDataSourceName), dataSourceState);
    }

    private String getCacheKey(String databaseName, String dataSourceName) {
        return databaseName + "." + dataSourceName;
    }

    @Generated
    private DataSourceStateManager() {
    }
}

