/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.builder.dialect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsBuilder;

public final class PostgreSQLShardingSphereStatisticsBuilder
implements ShardingSphereStatisticsBuilder {
    private static final String SHARDING_SPHERE = "shardingsphere";
    private static final String CLUSTER_INFORMATION = "cluster_information";
    private static final String SHARDING_TABLE_STATISTICS = "sharding_table_statistics";
    private static final Map<String, Collection<String>> INIT_DATA_SCHEMA_TABLES = new LinkedHashMap<String, Collection<String>>();

    @Override
    public ShardingSphereStatistics build(ShardingSphereMetaData metaData) {
        ShardingSphereStatistics result = new ShardingSphereStatistics();
        for (Map.Entry<String, ShardingSphereDatabase> entry : metaData.getDatabases().entrySet()) {
            ShardingSphereDatabaseData databaseData = new ShardingSphereDatabaseData();
            this.initSchemas(entry.getValue(), databaseData);
            if (databaseData.getSchemaData().isEmpty()) continue;
            result.putDatabase(entry.getKey(), databaseData);
        }
        return result;
    }

    private void initSchemas(ShardingSphereDatabase database, ShardingSphereDatabaseData databaseData) {
        for (Map.Entry<String, ShardingSphereSchema> entry : database.getSchemas().entrySet()) {
            ShardingSphereSchemaData schemaData;
            if (SHARDING_SPHERE.equals(entry.getKey())) {
                schemaData = new ShardingSphereSchemaData();
                this.initClusterInformationTable(schemaData);
                this.initShardingTableStatisticsTable(schemaData);
                databaseData.putSchema(SHARDING_SPHERE, schemaData);
            }
            if (!INIT_DATA_SCHEMA_TABLES.containsKey(entry.getKey())) continue;
            schemaData = new ShardingSphereSchemaData();
            this.initTables(entry.getValue(), INIT_DATA_SCHEMA_TABLES.get(entry.getKey()), schemaData);
            databaseData.putSchema(entry.getKey(), schemaData);
        }
    }

    private void initClusterInformationTable(ShardingSphereSchemaData schemaData) {
        ShardingSphereTableData tableData = new ShardingSphereTableData(CLUSTER_INFORMATION);
        tableData.getRows().add(new ShardingSphereRowData(Collections.singletonList("5.5.0")));
        schemaData.putTable(CLUSTER_INFORMATION, tableData);
    }

    private void initShardingTableStatisticsTable(ShardingSphereSchemaData schemaData) {
        schemaData.putTable(SHARDING_TABLE_STATISTICS, new ShardingSphereTableData(SHARDING_TABLE_STATISTICS));
    }

    private void initTables(ShardingSphereSchema schema, Collection<String> tables, ShardingSphereSchemaData schemaData) {
        for (Map.Entry<String, ShardingSphereTable> entry : schema.getTables().entrySet()) {
            if (!tables.contains(entry.getValue().getName())) continue;
            ShardingSphereTableData tableData = new ShardingSphereTableData(entry.getValue().getName());
            schemaData.putTable(entry.getKey(), tableData);
        }
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    static {
        INIT_DATA_SCHEMA_TABLES.put("pg_catalog", Arrays.asList("pg_class", "pg_namespace"));
    }
}

