/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRulesBuilder;
import org.apache.shardingsphere.infra.state.datasource.DataSourceStateManager;

public final class ShardingSphereDatabase {
    private final String name;
    private final DatabaseType protocolType;
    private final ResourceMetaData resourceMetaData;
    private final RuleMetaData ruleMetaData;
    private final Map<String, ShardingSphereSchema> schemas;

    public ShardingSphereDatabase(String name, DatabaseType protocolType, ResourceMetaData resourceMetaData, RuleMetaData ruleMetaData, Map<String, ShardingSphereSchema> schemas) {
        this.name = name;
        this.protocolType = protocolType;
        this.resourceMetaData = resourceMetaData;
        this.ruleMetaData = ruleMetaData;
        this.schemas = new ConcurrentHashMap<String, ShardingSphereSchema>(schemas.size(), 1.0f);
        schemas.forEach((key, value) -> this.schemas.put(key.toLowerCase(), (ShardingSphereSchema)value));
    }

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType, Map<String, DatabaseType> storageTypes, DatabaseConfiguration databaseConfig, ConfigurationProperties props, InstanceContext instanceContext) throws SQLException {
        Collection<ShardingSphereRule> databaseRules = DatabaseRulesBuilder.build(name, protocolType, databaseConfig, instanceContext);
        ConcurrentHashMap<String, ShardingSphereSchema> schemas = new ConcurrentHashMap<String, ShardingSphereSchema>(GenericSchemaBuilder.build(new GenericSchemaBuilderMaterial(protocolType, storageTypes, DataSourceStateManager.getInstance().getEnabledDataSources(name, databaseConfig), databaseRules, props, new DatabaseTypeRegistry(protocolType).getDefaultSchemaName(name))));
        SystemSchemaBuilder.build(name, protocolType, props).forEach(schemas::putIfAbsent);
        return ShardingSphereDatabase.create(name, protocolType, databaseConfig, databaseRules, schemas);
    }

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType, ConfigurationProperties props) {
        DataSourceProvidedDatabaseConfiguration databaseConfig = new DataSourceProvidedDatabaseConfiguration(new LinkedHashMap<String, DataSource>(), new LinkedList<RuleConfiguration>());
        return ShardingSphereDatabase.create(name, protocolType, databaseConfig, new LinkedList<ShardingSphereRule>(), SystemSchemaBuilder.build(name, protocolType, props));
    }

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType, DatabaseConfiguration databaseConfig, Collection<ShardingSphereRule> rules, Map<String, ShardingSphereSchema> schemas) {
        ResourceMetaData resourceMetaData = ShardingSphereDatabase.createResourceMetaData(databaseConfig.getDataSources(), databaseConfig.getStorageUnits());
        RuleMetaData ruleMetaData = new RuleMetaData(rules);
        return new ShardingSphereDatabase(name, protocolType, resourceMetaData, ruleMetaData, schemas);
    }

    private static ResourceMetaData createResourceMetaData(Map<StorageNode, DataSource> dataSources, Map<String, StorageUnit> storageUnits) {
        return new ResourceMetaData(dataSources, storageUnits);
    }

    public boolean containsSchema(String schemaName) {
        return this.schemas.containsKey(schemaName.toLowerCase());
    }

    public ShardingSphereSchema getSchema(String schemaName) {
        return this.schemas.get(schemaName.toLowerCase());
    }

    public void addSchema(String schemaName, ShardingSphereSchema schema) {
        this.schemas.put(schemaName.toLowerCase(), schema);
    }

    public void dropSchema(String schemaName) {
        this.schemas.remove(schemaName.toLowerCase());
    }

    public boolean isComplete() {
        return !this.ruleMetaData.getRules().isEmpty() && !this.resourceMetaData.getStorageUnits().isEmpty();
    }

    public boolean containsDataSource() {
        return !this.resourceMetaData.getStorageUnits().isEmpty();
    }

    public synchronized void reloadRules() {
        Collection toBeReloadedRules = this.ruleMetaData.getRules().stream().filter(each -> each.getAttributes().findAttribute(MutableDataNodeRuleAttribute.class).isPresent()).collect(Collectors.toList());
        RuleConfiguration ruleConfig = toBeReloadedRules.stream().map(ShardingSphereRule::getConfiguration).findFirst().orElse(null);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(this.ruleMetaData.getRules());
        toBeReloadedRules.stream().findFirst().ifPresent(optional -> {
            rules.removeAll(toBeReloadedRules);
            Map dataSources = this.resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
            rules.add(optional.getAttributes().getAttribute(MutableDataNodeRuleAttribute.class).reloadRule(ruleConfig, this.name, dataSources, rules));
        });
        this.ruleMetaData.getRules().clear();
        this.ruleMetaData.getRules().addAll(rules);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DatabaseType getProtocolType() {
        return this.protocolType;
    }

    @Generated
    public ResourceMetaData getResourceMetaData() {
        return this.resourceMetaData;
    }

    @Generated
    public RuleMetaData getRuleMetaData() {
        return this.ruleMetaData;
    }

    @Generated
    public Map<String, ShardingSphereSchema> getSchemas() {
        return this.schemas;
    }
}

