/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.state.datasource.DataSourceStateManager;

public final class DatabaseTypeEngine {
    private static final String DEFAULT_DATABASE_TYPE = "MySQL";

    public static DatabaseType getProtocolType(String databaseName, DatabaseConfiguration databaseConfig, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Collection<DataSource> enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSources(databaseName, databaseConfig).values();
        return enabledDataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType(enabledDataSources.iterator().next());
    }

    public static DatabaseType getProtocolType(Map<String, ? extends DatabaseConfiguration> databaseConfigs, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Map<String, DataSource> enabledDataSources = DatabaseTypeEngine.getEnabledDataSources(databaseConfigs);
        return enabledDataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType(enabledDataSources.values().iterator().next());
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType(ConfigurationProperties props) {
        DatabaseType configuredDatabaseType = (DatabaseType)props.getValue(ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return null == configuredDatabaseType ? Optional.empty() : Optional.of(configuredDatabaseType.getTrunkDatabaseType().orElse(configuredDatabaseType));
    }

    private static Map<String, DataSource> getEnabledDataSources(Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, ? extends DatabaseConfiguration> entry : databaseConfigs.entrySet()) {
            result.putAll(DataSourceStateManager.getInstance().getEnabledDataSources(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static Map<String, DatabaseType> getStorageTypes(String databaseName, DatabaseConfiguration databaseConfig) {
        LinkedHashMap<String, DatabaseType> result = new LinkedHashMap<String, DatabaseType>(databaseConfig.getStorageUnits().size(), 1.0f);
        Map<String, DataSource> enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSources(databaseName, databaseConfig);
        for (Map.Entry<String, DataSource> entry : enabledDataSources.entrySet()) {
            result.put(entry.getKey(), DatabaseTypeEngine.getStorageType(entry.getValue()));
        }
        return result;
    }

    public static DatabaseType getStorageType(DataSource dataSource) {
        DatabaseType databaseType;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                databaseType = DatabaseTypeFactory.get((String)connection.getMetaData().getURL());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new SQLWrapperException(ex);
                }
            }
            connection.close();
        }
        return databaseType;
    }

    public static DatabaseType getDefaultStorageType() {
        return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)DEFAULT_DATABASE_TYPE);
    }

    @Generated
    private DatabaseTypeEngine() {
    }
}

