/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.PropertiesDocument;

public class POIXMLProperties {
    private OPCPackage pkg;
    private CoreProperties core;
    private ExtendedProperties ext;
    private CustomProperties cust;

    public POIXMLProperties(OPCPackage docPackage) throws IOException, OpenXML4JException, XmlException {
        this.pkg = docPackage;
        PackageRelationshipCollection coreRel = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        if (coreRel.size() != 1) {
            throw new IllegalArgumentException("A document must always have core properties defined!");
        }
        this.core = new CoreProperties((PackagePropertiesPart)this.pkg.getPart(coreRel.getRelationship(0)));
        PackageRelationshipCollection extRel = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        if (extRel.size() == 1) {
            PropertiesDocument props = PropertiesDocument.Factory.parse((InputStream)this.pkg.getPart(extRel.getRelationship(0)).getInputStream());
            this.ext = new ExtendedProperties(props);
        } else {
            this.ext = new ExtendedProperties(PropertiesDocument.Factory.newInstance());
        }
        PackageRelationshipCollection custRel = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
        if (custRel.size() == 1) {
            org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument props = PropertiesDocument.Factory.parse((InputStream)this.pkg.getPart(custRel.getRelationship(0)).getInputStream());
            this.cust = new CustomProperties(props);
        } else {
            this.cust = new CustomProperties(PropertiesDocument.Factory.newInstance());
        }
    }

    public CoreProperties getCoreProperties() {
        return this.core;
    }

    public ExtendedProperties getExtendedProperties() {
        return this.ext;
    }

    public CustomProperties getCustomProperties() {
        return this.cust;
    }

    public void write(OPCPackage pkg) {
    }

    public class CustomProperties {
        private org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument props;

        private CustomProperties(org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument props) {
            this.props = props;
            if (props.getProperties() == null) {
                props.addNewProperties();
            }
        }

        public CTProperties getUnderlyingProperties() {
            return this.props.getProperties();
        }
    }

    public class ExtendedProperties {
        private PropertiesDocument props;

        private ExtendedProperties(PropertiesDocument props) {
            this.props = props;
            if (props.getProperties() == null) {
                props.addNewProperties();
            }
        }

        public org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties getUnderlyingProperties() {
            return this.props.getProperties();
        }
    }

    public class CoreProperties {
        private PackagePropertiesPart part;

        private CoreProperties(PackagePropertiesPart part) {
            this.part = part;
        }

        public void setTitle(String title) {
            this.part.setTitleProperty(title);
        }

        public String getTitle() {
            return this.part.getTitleProperty().getValue();
        }

        public PackagePropertiesPart getUnderlyingProperties() {
            return this.part;
        }
    }
}

