/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;

public final class RemoveAllText {
    private RemoveAllText() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            RemoveAllText.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                if (document.isEncrypted()) {
                    System.err.println("Error: Encrypted documents are not supported for this example.");
                    System.exit(1);
                }
                for (PDPage page : document.getPages()) {
                    RemoveAllText.removeAllTextTokens(page, document);
                }
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void processResources(PDResources resources) throws IOException {
        Iterable names = resources.getXObjectNames();
        for (COSName name : names) {
            PDXObject xobject = resources.getXObject(name);
            if (!(xobject instanceof PDFormXObject)) continue;
            RemoveAllText.removeAllTextTokens((PDFormXObject)xobject);
        }
    }

    private static void removeAllTextTokens(PDPage page, PDDocument document) throws IOException {
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        parser.parse();
        List tokens = parser.getTokens();
        ArrayList newTokens = new ArrayList();
        for (Object token : tokens) {
            String opname;
            if (token instanceof Operator && ("TJ".equals(opname = ((Operator)token).getName()) || "Tj".equals(opname))) {
                newTokens.remove(newTokens.size() - 1);
                continue;
            }
            newTokens.add(token);
        }
        PDStream newContents = new PDStream(document);
        OutputStream out = newContents.createOutputStream(COSName.FLATE_DECODE);
        ContentStreamWriter writer = new ContentStreamWriter(out);
        writer.writeTokens(newTokens);
        out.close();
        page.setContents(newContents);
        RemoveAllText.processResources(page.getResources());
    }

    private static void removeAllTextTokens(PDFormXObject xobject) throws IOException {
        PDStream stream = xobject.getContentStream();
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)xobject);
        parser.parse();
        List tokens = parser.getTokens();
        ArrayList newTokens = new ArrayList();
        for (Object token : tokens) {
            Operator op;
            if (token instanceof Operator && ("TJ".equals((op = (Operator)token).getName()) || "Tj".equals(op.getName()) || "'".equals(op.getName()) || "\"".equals(op.getName()))) {
                newTokens.remove(newTokens.size() - 1);
                continue;
            }
            newTokens.add(token);
        }
        OutputStream out = stream.createOutputStream(COSName.FLATE_DECODE);
        ContentStreamWriter writer = new ContentStreamWriter(out);
        writer.writeTokens(newTokens);
        out.close();
        RemoveAllText.processResources(xobject.getResources());
    }

    private static void usage() {
        System.err.println("Usage: java " + RemoveAllText.class.getName() + " <input-pdf> <output-pdf>");
    }
}

