/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class DrawPrintTextLocations
extends PDFTextStripper {
    private BufferedImage image;
    private AffineTransform flipAT;
    private AffineTransform rotateAT;
    private AffineTransform transAT;
    private final String filename;
    static final int SCALE = 4;
    private Graphics2D g2d;
    private final PDDocument document;

    public DrawPrintTextLocations(PDDocument document, String filename) throws IOException {
        this.document = document;
        this.filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            DrawPrintTextLocations.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                DrawPrintTextLocations stripper = new DrawPrintTextLocations(document, args[0]);
                stripper.setSortByPosition(true);
                for (int page = 0; page < document.getNumberOfPages(); ++page) {
                    stripper.stripPage(page);
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        super.showGlyph(textRenderingMatrix, font, code, unicode, displacement);
        Shape cyanShape = this.calculateGlyphBounds(textRenderingMatrix, font, code);
        if (cyanShape != null) {
            cyanShape = this.flipAT.createTransformedShape(cyanShape);
            cyanShape = this.rotateAT.createTransformedShape(cyanShape);
            cyanShape = this.transAT.createTransformedShape(cyanShape);
            this.g2d.setColor(Color.CYAN);
            this.g2d.draw(cyanShape);
        }
    }

    private Shape calculateGlyphBounds(Matrix textRenderingMatrix, PDFont font, int code) throws IOException {
        GeneralPath path = null;
        AffineTransform at = textRenderingMatrix.createAffineTransform();
        at.concatenate(font.getFontMatrix().createAffineTransform());
        if (font instanceof PDType3Font) {
            PDType3Font t3Font = (PDType3Font)font;
            PDType3CharProc charProc = t3Font.getCharProc(code);
            if (charProc != null) {
                BoundingBox fontBBox = t3Font.getBoundingBox();
                PDRectangle glyphBBox = charProc.getGlyphBBox();
                if (glyphBBox != null) {
                    glyphBBox.setLowerLeftX(Math.max(fontBBox.getLowerLeftX(), glyphBBox.getLowerLeftX()));
                    glyphBBox.setLowerLeftY(Math.max(fontBBox.getLowerLeftY(), glyphBBox.getLowerLeftY()));
                    glyphBBox.setUpperRightX(Math.min(fontBBox.getUpperRightX(), glyphBBox.getUpperRightX()));
                    glyphBBox.setUpperRightY(Math.min(fontBBox.getUpperRightY(), glyphBBox.getUpperRightY()));
                    path = glyphBBox.toGeneralPath();
                }
            }
        } else if (font instanceof PDVectorFont) {
            PDType0Font t0font;
            int unitsPerEm;
            PDVectorFont vectorFont = (PDVectorFont)font;
            path = vectorFont.getPath(code);
            if (font instanceof PDTrueTypeFont) {
                PDTrueTypeFont ttFont = (PDTrueTypeFont)font;
                unitsPerEm = ttFont.getTrueTypeFont().getHeader().getUnitsPerEm();
                at.scale(1000.0 / (double)unitsPerEm, 1000.0 / (double)unitsPerEm);
            }
            if (font instanceof PDType0Font && (t0font = (PDType0Font)font).getDescendantFont() instanceof PDCIDFontType2) {
                unitsPerEm = ((PDCIDFontType2)t0font.getDescendantFont()).getTrueTypeFont().getHeader().getUnitsPerEm();
                at.scale(1000.0 / (double)unitsPerEm, 1000.0 / (double)unitsPerEm);
            }
        } else if (font instanceof PDSimpleFont) {
            PDSimpleFont simpleFont = (PDSimpleFont)font;
            String name = simpleFont.getEncoding().getName(code);
            path = simpleFont.getPath(name);
        } else {
            System.out.println("Unknown font class: " + font.getClass());
        }
        if (path == null) {
            return null;
        }
        return at.createTransformedShape(path.getBounds2D());
    }

    private void stripPage(int page) throws IOException {
        PDFRenderer pdfRenderer = new PDFRenderer(this.document);
        this.image = pdfRenderer.renderImage(page, 4.0f);
        PDPage pdPage = this.document.getPage(page);
        PDRectangle cropBox = pdPage.getCropBox();
        this.flipAT = new AffineTransform();
        this.flipAT.translate(0.0, pdPage.getBBox().getHeight());
        this.flipAT.scale(1.0, -1.0);
        this.rotateAT = new AffineTransform();
        int rotation = pdPage.getRotation();
        if (rotation != 0) {
            PDRectangle mediaBox = pdPage.getMediaBox();
            switch (rotation) {
                case 90: {
                    this.rotateAT.translate(mediaBox.getHeight(), 0.0);
                    break;
                }
                case 270: {
                    this.rotateAT.translate(0.0, mediaBox.getWidth());
                    break;
                }
                case 180: {
                    this.rotateAT.translate(mediaBox.getWidth(), mediaBox.getHeight());
                    break;
                }
            }
            this.rotateAT.rotate(Math.toRadians(rotation));
        }
        this.transAT = AffineTransform.getTranslateInstance(-cropBox.getLowerLeftX(), cropBox.getLowerLeftY());
        this.g2d = this.image.createGraphics();
        this.g2d.setStroke(new BasicStroke(0.1f));
        this.g2d.scale(4.0, 4.0);
        this.setStartPage(page + 1);
        this.setEndPage(page + 1);
        OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
        this.writeText(this.document, dummy);
        this.g2d.setStroke(new BasicStroke(0.4f));
        List pageArticles = pdPage.getThreadBeads();
        for (PDThreadBead bead : pageArticles) {
            PDRectangle r = bead.getRectangle();
            Shape s = r.toGeneralPath().createTransformedShape(this.transAT);
            s = this.flipAT.createTransformedShape(s);
            s = this.rotateAT.createTransformedShape(s);
            this.g2d.setColor(Color.green);
            this.g2d.draw(s);
        }
        this.g2d.dispose();
        String imageFilename = this.filename;
        int pt = imageFilename.lastIndexOf(46);
        imageFilename = imageFilename.substring(0, pt) + "-marked-" + (page + 1) + ".png";
        ImageIO.write((RenderedImage)this.image, "png", new File(imageFilename));
    }

    protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
        for (TextPosition text : textPositions) {
            System.out.println("String[" + text.getXDirAdj() + "," + text.getYDirAdj() + " fs=" + text.getFontSize() + " xscale=" + text.getXScale() + " height=" + text.getHeightDir() + " space=" + text.getWidthOfSpace() + " width=" + text.getWidthDirAdj() + "]" + text.getUnicode());
            AffineTransform at = text.getTextMatrix().createAffineTransform();
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, text.getWidthDirAdj() / text.getTextMatrix().getScalingFactorX(), text.getHeightDir() / text.getTextMatrix().getScalingFactorY());
            Shape s = at.createTransformedShape(rect);
            s = this.flipAT.createTransformedShape(s);
            s = this.rotateAT.createTransformedShape(s);
            this.g2d.setColor(Color.red);
            this.g2d.draw(s);
            PDFont font = text.getFont();
            BoundingBox bbox = font.getBoundingBox();
            float xadvance = font.getWidth(text.getCharacterCodes()[0]);
            rect = new Rectangle2D.Float(0.0f, bbox.getLowerLeftY(), xadvance, bbox.getHeight());
            if (font instanceof PDType3Font) {
                at.concatenate(font.getFontMatrix().createAffineTransform());
            } else {
                at.scale(0.001f, 0.001f);
            }
            s = at.createTransformedShape(rect);
            s = this.flipAT.createTransformedShape(s);
            s = this.rotateAT.createTransformedShape(s);
            this.g2d.setColor(Color.blue);
            this.g2d.draw(s);
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + DrawPrintTextLocations.class.getName() + " <input-pdf>");
    }
}

