/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;

public final class ShowSignature {
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    private ShowSignature() {
    }

    public static void main(String[] args) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        ShowSignature show = new ShowSignature();
        show.showSignature(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSignature(String[] args) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (args.length != 2) {
            ShowSignature.usage();
        } else {
            String password = args[0];
            File infile = new File(args[1]);
            PDDocument document = null;
            try {
                document = PDDocument.load((File)infile, (String)password);
                for (PDSignature sig : document.getSignatureDictionaries()) {
                    COSDictionary sigDict = sig.getCOSObject();
                    COSString contents = (COSString)sigDict.getDictionaryObject(COSName.CONTENTS);
                    FileInputStream fis = new FileInputStream(infile);
                    byte[] buf = null;
                    try {
                        buf = sig.getSignedContent((InputStream)fis);
                    }
                    finally {
                        fis.close();
                    }
                    System.out.println("Signature found");
                    int[] byteRange = sig.getByteRange();
                    if (byteRange.length != 4) {
                        System.err.println("Signature byteRange must have 4 items");
                    } else {
                        long fileLen = infile.length();
                        long rangeMax = (long)byteRange[2] + (long)byteRange[3];
                        int contentLen = sigDict.getString(COSName.CONTENTS).length() * 2 + 2;
                        if (fileLen != rangeMax || byteRange[0] != 0 || byteRange[1] + contentLen != byteRange[2]) {
                            System.out.println("Signature does not cover whole document");
                        } else {
                            System.out.println("Signature covers whole document");
                        }
                    }
                    System.out.println("Name:     " + sig.getName());
                    System.out.println("Modified: " + this.sdf.format(sig.getSignDate().getTime()));
                    String subFilter = sig.getSubFilter();
                    if (subFilter != null) {
                        Collection<? extends Certificate> certs;
                        CertificateFactory factory;
                        COSString certString;
                        if (subFilter.equals("adbe.pkcs7.detached")) {
                            this.verifyPKCS7(buf, contents, sig);
                            continue;
                        }
                        if (subFilter.equals("adbe.pkcs7.sha1")) {
                            certString = (COSString)sigDict.getDictionaryObject(COSName.CONTENTS);
                            byte[] certData = certString.getBytes();
                            factory = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream certStream = new ByteArrayInputStream(certData);
                            certs = factory.generateCertificates(certStream);
                            System.out.println("certs=" + certs);
                            byte[] hash = MessageDigest.getInstance("SHA1").digest(buf);
                            this.verifyPKCS7(hash, contents, sig);
                            continue;
                        }
                        if (subFilter.equals("adbe.x509.rsa_sha1")) {
                            certString = (COSString)sigDict.getDictionaryObject(COSName.getPDFName((String)"Cert"));
                            byte[] certData = certString.getBytes();
                            factory = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream certStream = new ByteArrayInputStream(certData);
                            certs = factory.generateCertificates(certStream);
                            System.out.println("certs=" + certs);
                            continue;
                        }
                        System.err.println("Unknown certificate type: " + subFilter);
                        continue;
                    }
                    throw new IOException("Missing subfilter for cert dictionary");
                }
            }
            catch (CMSException ex) {
                throw new IOException(ex);
            }
            catch (OperatorCreationException ex) {
                throw new IOException(ex);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private void verifyPKCS7(byte[] byteArray, COSString contents, PDSignature sig) throws CMSException, CertificateException, StoreException, OperatorCreationException, NoSuchAlgorithmException, NoSuchProviderException {
        CMSProcessableByteArray signedContent = new CMSProcessableByteArray(byteArray);
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)signedContent, contents.getBytes());
        Store certificatesStore = signedData.getCertificates();
        Collection signers = signedData.getSignerInfos().getSigners();
        SignerInformation signerInformation = (SignerInformation)signers.iterator().next();
        Collection matches = certificatesStore.getMatches((Selector)signerInformation.getSID());
        X509CertificateHolder certificateHolder = (X509CertificateHolder)matches.iterator().next();
        X509Certificate certFromSignedData = new JcaX509CertificateConverter().getCertificate(certificateHolder);
        System.out.println("certFromSignedData: " + certFromSignedData);
        certFromSignedData.checkValidity(sig.getSignDate().getTime());
        if (this.isSelfSigned(certFromSignedData)) {
            System.err.println("Certificate is self-signed, LOL!");
        } else {
            System.out.println("Certificate is not self-signed");
        }
        if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().build(certFromSignedData))) {
            System.out.println("Signature verified");
        } else {
            System.out.println("Signature verification failed");
        }
    }

    private boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (SignatureException sigEx) {
            return false;
        }
        catch (InvalidKeyException keyEx) {
            return false;
        }
    }

    private static void usage() {
        System.err.println("usage: java " + ShowSignature.class.getName() + "<password> <inputfile>");
    }
}

