/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;

public final class CreateSimpleForm {
    private CreateSimpleForm() {
    }

    public static void main(String[] args) throws IOException {
        PDDocument document = new PDDocument();
        PDPage page = new PDPage(PDRectangle.A4);
        document.addPage(page);
        PDType1Font font = PDType1Font.HELVETICA;
        PDResources resources = new PDResources();
        resources.put(COSName.getPDFName((String)"Helv"), (PDFont)font);
        PDAcroForm acroForm = new PDAcroForm(document);
        document.getDocumentCatalog().setAcroForm(acroForm);
        acroForm.setDefaultResources(resources);
        String defaultAppearanceString = "/Helv 0 Tf 0 g";
        acroForm.setDefaultAppearance(defaultAppearanceString);
        PDTextField textBox = new PDTextField(acroForm);
        textBox.setPartialName("SampleField");
        defaultAppearanceString = "/Helv 12 Tf 0 0 1 rg";
        textBox.setDefaultAppearance(defaultAppearanceString);
        acroForm.getFields().add(textBox);
        PDAnnotationWidget widget = (PDAnnotationWidget)textBox.getWidgets().get(0);
        PDRectangle rect = new PDRectangle(50.0f, 750.0f, 200.0f, 50.0f);
        widget.setRectangle(rect);
        widget.setPage(page);
        PDAppearanceCharacteristicsDictionary fieldAppearance = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        fieldAppearance.setBorderColour(new PDColor(new float[]{0.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        fieldAppearance.setBackground(new PDColor(new float[]{1.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        widget.setAppearanceCharacteristics(fieldAppearance);
        widget.setPrinted(true);
        page.getAnnotations().add(widget);
        textBox.setValue("Sample field");
        document.save("target/SimpleForm.pdf");
        document.close();
    }
}

