/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.PDFOperator;

public class RemoveAllText {
    private RemoveAllText() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            RemoveAllText.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((String)args[0]);
                if (document.isEncrypted()) {
                    System.err.println("Error: Encrypted documents are not supported for this example.");
                    System.exit(1);
                }
                List allPages = document.getDocumentCatalog().getAllPages();
                for (int i = 0; i < allPages.size(); ++i) {
                    PDPage page = (PDPage)allPages.get(i);
                    PDFStreamParser parser = new PDFStreamParser(page.getContents());
                    parser.parse();
                    List tokens = parser.getTokens();
                    ArrayList newTokens = new ArrayList();
                    for (int j = 0; j < tokens.size(); ++j) {
                        PDFOperator op;
                        Object token = tokens.get(j);
                        if (token instanceof PDFOperator && ((op = (PDFOperator)token).getOperation().equals("TJ") || op.getOperation().equals("Tj"))) {
                            newTokens.remove(newTokens.size() - 1);
                            continue;
                        }
                        newTokens.add(token);
                    }
                    PDStream newContents = new PDStream(document);
                    ContentStreamWriter writer = new ContentStreamWriter(newContents.createOutputStream());
                    writer.writeTokens(newTokens);
                    newContents.addCompression();
                    page.setContents(newContents);
                }
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.RemoveAllText <input-pdf> <output-pdf>");
    }
}

