/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class PrintBookmarks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            PrintBookmarks.usage();
        } else {
            PDDocument document = null;
            FileInputStream file = null;
            try {
                file = new FileInputStream(args[0]);
                PDFParser parser = new PDFParser((InputStream)file);
                parser.parse();
                document = parser.getPDDocument();
                if (document.isEncrypted()) {
                    document.decrypt("");
                }
                PrintBookmarks meta = new PrintBookmarks();
                PDDocumentOutline outline = document.getDocumentCatalog().getDocumentOutline();
                if (outline != null) {
                    meta.printBookmark((PDOutlineNode)outline, "");
                } else {
                    System.out.println("This document does not contain any bookmarks");
                }
            }
            finally {
                if (file != null) {
                    file.close();
                }
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.PrintBookmarks <input-pdf>");
    }

    public void printBookmark(PDOutlineNode bookmark, String indentation) throws IOException {
        for (PDOutlineItem current = bookmark.getFirstChild(); current != null; current = current.getNextSibling()) {
            System.out.println(indentation + current.getTitle());
            this.printBookmark((PDOutlineNode)current, indentation + "    ");
        }
    }
}

