/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2Font;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;

public class ExtractTTFFonts {
    private int fontCounter = 1;
    private static final String PASSWORD = "-password";
    private static final String PREFIX = "-prefix";
    private static final String ADDKEY = "-addkey";

    private ExtractTTFFonts() {
    }

    public static void main(String[] args) throws Exception {
        ExtractTTFFonts extractor = new ExtractTTFFonts();
        extractor.extractFonts(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFonts(String[] args) throws Exception {
        if (args.length < 1 || args.length > 4) {
            ExtractTTFFonts.usage();
        } else {
            String pdfFile = null;
            String password = "";
            String prefix = null;
            boolean addKey = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        ExtractTTFFonts.usage();
                    }
                    password = args[i];
                    continue;
                }
                if (args[i].equals(PREFIX)) {
                    if (++i >= args.length) {
                        ExtractTTFFonts.usage();
                    }
                    prefix = args[i];
                    continue;
                }
                if (args[i].equals(ADDKEY)) {
                    addKey = true;
                    continue;
                }
                if (pdfFile != null) continue;
                pdfFile = args[i];
            }
            if (pdfFile == null) {
                ExtractTTFFonts.usage();
            } else {
                if (prefix == null && pdfFile.length() > 4) {
                    prefix = pdfFile.substring(0, pdfFile.length() - 4);
                }
                PDDocument document = null;
                try {
                    document = PDDocument.load((String)pdfFile);
                    if (document.isEncrypted()) {
                        document.decrypt(password);
                    }
                    List pages = document.getDocumentCatalog().getAllPages();
                    for (PDPage page : pages) {
                        PDResources resources = page.getResources();
                        this.processResources(resources, prefix, addKey);
                    }
                }
                finally {
                    if (document != null) {
                        document.close();
                    }
                }
            }
        }
    }

    private void processResources(PDResources resources, String prefix, boolean addKey) throws IOException {
        Map xobjects;
        if (resources == null) {
            return;
        }
        Map fonts = resources.getFonts();
        if (fonts != null) {
            for (String key : fonts.keySet()) {
                PDStream ff2Stream;
                PDFont font = (PDFont)fonts.get(key);
                if (!(font instanceof PDCIDFontType2Font) && !(font instanceof PDTrueTypeFont)) continue;
                String name = null;
                name = addKey ? this.getUniqueFileName(prefix + "_" + key, "ttf") : this.getUniqueFileName(prefix, "ttf");
                PDFontDescriptorDictionary fd = (PDFontDescriptorDictionary)font.getFontDescriptor();
                if (fd == null || (ff2Stream = fd.getFontFile2()) == null) continue;
                System.out.println("Writing font:" + name);
                FileOutputStream fos = new FileOutputStream(new File(name + ".ttf"));
                IOUtils.copy((InputStream)ff2Stream.createInputStream(), (OutputStream)fos);
                fos.close();
            }
        }
        if ((xobjects = resources.getXObjects()) != null) {
            for (String key : xobjects.keySet()) {
                PDXObject xobject = (PDXObject)xobjects.get(key);
                if (!(xobject instanceof PDXObjectForm)) continue;
                PDXObjectForm xObjectForm = (PDXObjectForm)xobject;
                PDResources formResources = xObjectForm.getResources();
                this.processResources(formResources, prefix, addKey);
            }
        }
    }

    private String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.fontCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.fontCounter;
        }
        return uniqueName;
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.ExtractTTFFonts [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -prefix  <font-prefix>       Font prefix(default to pdf name)\n  -addkey                      add the internal font key to the file name\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }
}

