/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.fdf;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class PrintFields {
    public void printFields(PDDocument pdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        List fields = acroForm.getFields();
        Iterator fieldsIter = fields.iterator();
        System.out.println(new Integer(fields.size()).toString() + " top-level fields were found on the form");
        while (fieldsIter.hasNext()) {
            PDField field = (PDField)fieldsIter.next();
            this.processField(field, "|--", field.getPartialName());
        }
    }

    private void processField(PDField field, String sLevel, String sParent) throws IOException {
        List kids = field.getKids();
        String partialName = field.getPartialName();
        if (kids != null) {
            Iterator kidsIter = kids.iterator();
            if (!sParent.equals(partialName) && partialName != null) {
                sParent = sParent + "." + partialName;
            }
            System.out.println(sLevel + sParent);
            while (kidsIter.hasNext()) {
                Object pdfObj = kidsIter.next();
                if (!(pdfObj instanceof PDField)) continue;
                PDField kid = (PDField)pdfObj;
                this.processField(kid, "|  " + sLevel, sParent);
            }
        } else {
            String fieldValue = null;
            fieldValue = field instanceof PDSignatureField ? "PDSignatureField" : (field.getValue() != null ? field.getValue() : "no value available");
            StringBuilder outputString = new StringBuilder(sLevel + sParent);
            if (partialName != null) {
                outputString.append("." + partialName);
            }
            outputString.append(" = " + fieldValue);
            outputString.append(",  type=" + field.getClass().getName());
            System.out.println(outputString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CryptographyException {
        PDDocument pdf = null;
        try {
            if (args.length != 1) {
                PrintFields.usage();
            } else {
                pdf = PDDocument.load((String)args[0]);
                PrintFields exporter = new PrintFields();
                if (pdf.isEncrypted()) {
                    pdf.decrypt("");
                }
                exporter.printFields(pdf);
            }
        }
        finally {
            if (pdf != null) {
                pdf.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: org.apache.pdfbox.examples.fdf.PrintFields <pdf-file>");
    }
}

