package org.apache.parquet.filter2.recordlevel;

import java.util.List;
import java.util.Set;

import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.filter2.predicate.Operators.Eq;
import org.apache.parquet.filter2.predicate.Operators.Gt;
import org.apache.parquet.filter2.predicate.Operators.GtEq;
import org.apache.parquet.filter2.predicate.Operators.In;
import org.apache.parquet.filter2.predicate.Operators.LogicalNotUserDefined;
import org.apache.parquet.filter2.predicate.Operators.Lt;
import org.apache.parquet.filter2.predicate.Operators.LtEq;
import org.apache.parquet.filter2.predicate.Operators.NotEq;
import org.apache.parquet.filter2.predicate.Operators.NotIn;
import org.apache.parquet.filter2.predicate.Operators.UserDefined;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate.ValueInspector;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.PrimitiveComparator;

/**
 * This class is auto-generated by org.apache.parquet.filter2.IncrementallyUpdatedFilterPredicateGenerator
 * Do not manually edit!
 * See {@link IncrementallyUpdatedFilterPredicateBuilderBase}
 */
public class IncrementallyUpdatedFilterPredicateBuilder extends IncrementallyUpdatedFilterPredicateBuilderBase {

  public IncrementallyUpdatedFilterPredicateBuilder(List<PrimitiveColumnIO> leaves) {
    super(leaves);
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Eq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(int value) {
            setResult(false);
          }
        };
      } else {
        final int target = (Integer) (Object) pred.getValue();
        final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(int value) {
            setResult(comparator.compare(value, target) == 0 );
          }
        };
      }
    }

    if (clazz.equals(Long.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(long value) {
            setResult(false);
          }
        };
      } else {
        final long target = (Long) (Object) pred.getValue();
        final PrimitiveComparator<Long> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(long value) {
            setResult(comparator.compare(value, target) == 0 );
          }
        };
      }
    }

    if (clazz.equals(Boolean.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(boolean value) {
            setResult(false);
          }
        };
      } else {
        final boolean target = (Boolean) (Object) pred.getValue();
        final PrimitiveComparator<Boolean> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(boolean value) {
            setResult(comparator.compare(value, target) == 0 );
          }
        };
      }
    }

    if (clazz.equals(Float.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(float value) {
            setResult(false);
          }
        };
      } else {
        final float target = (Float) (Object) pred.getValue();
        final PrimitiveComparator<Float> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(float value) {
            setResult(comparator.compare(value, target) == 0 );
          }
        };
      }
    }

    if (clazz.equals(Double.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(double value) {
            setResult(false);
          }
        };
      } else {
        final double target = (Double) (Object) pred.getValue();
        final PrimitiveComparator<Double> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(double value) {
            setResult(comparator.compare(value, target) == 0 );
          }
        };
      }
    }

    if (clazz.equals(Binary.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(Binary value) {
            setResult(false);
          }
        };
      } else {
        final Binary target = (Binary) (Object) pred.getValue();
        final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(Binary value) {
            setResult(comparator.compare(value, target) == 0 );
          }
        };
      }
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(NotEq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(int value) {
            setResult(true);
          }
        };
      } else {
        final int target = (Integer) (Object) pred.getValue();
        final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(int value) {
            setResult(comparator.compare(value, target) != 0);
          }
        };
      }
    }

    if (clazz.equals(Long.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(long value) {
            setResult(true);
          }
        };
      } else {
        final long target = (Long) (Object) pred.getValue();
        final PrimitiveComparator<Long> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(long value) {
            setResult(comparator.compare(value, target) != 0);
          }
        };
      }
    }

    if (clazz.equals(Boolean.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(boolean value) {
            setResult(true);
          }
        };
      } else {
        final boolean target = (Boolean) (Object) pred.getValue();
        final PrimitiveComparator<Boolean> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(boolean value) {
            setResult(comparator.compare(value, target) != 0);
          }
        };
      }
    }

    if (clazz.equals(Float.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(float value) {
            setResult(true);
          }
        };
      } else {
        final float target = (Float) (Object) pred.getValue();
        final PrimitiveComparator<Float> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(float value) {
            setResult(comparator.compare(value, target) != 0);
          }
        };
      }
    }

    if (clazz.equals(Double.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(double value) {
            setResult(true);
          }
        };
      } else {
        final double target = (Double) (Object) pred.getValue();
        final PrimitiveComparator<Double> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(double value) {
            setResult(comparator.compare(value, target) != 0);
          }
        };
      }
    }

    if (clazz.equals(Binary.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(Binary value) {
            setResult(true);
          }
        };
      } else {
        final Binary target = (Binary) (Object) pred.getValue();
        final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(Binary value) {
            setResult(comparator.compare(value, target) != 0);
          }
        };
      }
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(In<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(int value) {
            setResult(false);
          }
        };
      } else {
        final Set<Integer> target = (Set<Integer>) pred.getValues();
        final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(int value) {
            boolean set = false;
            for (int i : target) {
              if(comparator.compare(value, i) == 0 ) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Long.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(long value) {
            setResult(false);
          }
        };
      } else {
        final Set<Long> target = (Set<Long>) pred.getValues();
        final PrimitiveComparator<Long> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(long value) {
            boolean set = false;
            for (long i : target) {
              if(comparator.compare(value, i) == 0 ) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Boolean.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(boolean value) {
            setResult(false);
          }
        };
      } else {
        final Set<Boolean> target = (Set<Boolean>) pred.getValues();
        final PrimitiveComparator<Boolean> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(boolean value) {
            boolean set = false;
            for (boolean i : target) {
              if(comparator.compare(value, i) == 0 ) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Float.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(float value) {
            setResult(false);
          }
        };
      } else {
        final Set<Float> target = (Set<Float>) pred.getValues();
        final PrimitiveComparator<Float> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(float value) {
            boolean set = false;
            for (float i : target) {
              if(comparator.compare(value, i) == 0 ) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Double.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(double value) {
            setResult(false);
          }
        };
      } else {
        final Set<Double> target = (Set<Double>) pred.getValues();
        final PrimitiveComparator<Double> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(double value) {
            boolean set = false;
            for (double i : target) {
              if(comparator.compare(value, i) == 0 ) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Binary.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(Binary value) {
            setResult(false);
          }
        };
      } else {
        final Set<Binary> target = (Set<Binary>) pred.getValues();
        final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(Binary value) {
            boolean set = false;
            for (Binary i : target) {
              if(comparator.compare(value, i) == 0 ) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(NotIn<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(int value) {
            setResult(true);
          }
        };
      } else {
        final Set<Integer> target = (Set<Integer>) pred.getValues();
        final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(int value) {
            boolean set = false;
            for (int i : target) {
              if(comparator.compare(value, i) != 0) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Long.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(long value) {
            setResult(true);
          }
        };
      } else {
        final Set<Long> target = (Set<Long>) pred.getValues();
        final PrimitiveComparator<Long> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(long value) {
            boolean set = false;
            for (long i : target) {
              if(comparator.compare(value, i) != 0) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Boolean.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(boolean value) {
            setResult(true);
          }
        };
      } else {
        final Set<Boolean> target = (Set<Boolean>) pred.getValues();
        final PrimitiveComparator<Boolean> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(boolean value) {
            boolean set = false;
            for (boolean i : target) {
              if(comparator.compare(value, i) != 0) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Float.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(float value) {
            setResult(true);
          }
        };
      } else {
        final Set<Float> target = (Set<Float>) pred.getValues();
        final PrimitiveComparator<Float> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(float value) {
            boolean set = false;
            for (float i : target) {
              if(comparator.compare(value, i) != 0) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Double.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(double value) {
            setResult(true);
          }
        };
      } else {
        final Set<Double> target = (Set<Double>) pred.getValues();
        final PrimitiveComparator<Double> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(double value) {
            boolean set = false;
            for (double i : target) {
              if(comparator.compare(value, i) != 0) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (clazz.equals(Binary.class)) {
      if (pred.getValues().contains(null)) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(Binary value) {
            setResult(true);
          }
        };
      } else {
        final Set<Binary> target = (Set<Binary>) pred.getValues();
        final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(Binary value) {
            boolean set = false;
            for (Binary i : target) {
              if(comparator.compare(value, i) != 0) {
                 setResult(true);
                 set = true;
                 break;
               }
             }
             if (!set) setResult(false);
           }
         };
       }
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Lt<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();
      final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(comparator.compare(value, target) < 0);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();
      final PrimitiveComparator<Long> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(comparator.compare(value, target) < 0);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator < not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();
      final PrimitiveComparator<Float> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(comparator.compare(value, target) < 0);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();
      final PrimitiveComparator<Double> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(comparator.compare(value, target) < 0);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();
      final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(comparator.compare(value, target) < 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(LtEq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();
      final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(comparator.compare(value, target) <= 0);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();
      final PrimitiveComparator<Long> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(comparator.compare(value, target) <= 0);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator <= not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();
      final PrimitiveComparator<Float> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(comparator.compare(value, target) <= 0);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();
      final PrimitiveComparator<Double> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(comparator.compare(value, target) <= 0);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();
      final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(comparator.compare(value, target) <= 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Gt<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();
      final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(comparator.compare(value, target) > 0);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();
      final PrimitiveComparator<Long> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(comparator.compare(value, target) > 0);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator > not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();
      final PrimitiveComparator<Float> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(comparator.compare(value, target) > 0);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();
      final PrimitiveComparator<Double> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(comparator.compare(value, target) > 0);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();
      final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(comparator.compare(value, target) > 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(GtEq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();
      final PrimitiveComparator<Integer> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(comparator.compare(value, target) >= 0);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();
      final PrimitiveComparator<Long> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(comparator.compare(value, target) >= 0);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator >= not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();
      final PrimitiveComparator<Float> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(comparator.compare(value, target) >= 0);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();
      final PrimitiveComparator<Double> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(comparator.compare(value, target) >= 0);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();
      final PrimitiveComparator<Binary> comparator = getComparator(columnPath);

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(comparator.compare(value, target) >= 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(UserDefined<T, U> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    final U udp = pred.getUserDefinedPredicate();

    if (clazz.equals(Integer.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(int value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Long.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(long value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(boolean value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Float.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(float value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Double.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(double value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(Binary value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(LogicalNotUserDefined<T, U> notPred) {
    UserDefined<T, U> pred = notPred.getUserDefined();
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    final U udp = pred.getUserDefinedPredicate();

    if (clazz.equals(Integer.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(int value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Long.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(long value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(boolean value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Float.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(float value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Double.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(double value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.acceptsNullValue());
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(Binary value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

}
