/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Singleton;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.container.SerializableBeanVault;
import org.apache.webbeans.context.WebBeansContext;
import org.apache.webbeans.context.creational.BeanInstanceBag;
import org.apache.webbeans.context.type.ContextTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
implements WebBeansContext,
Serializable {
    protected volatile boolean active;
    protected ContextTypes type;
    protected Map<Contextual<?>, BeanInstanceBag<?>> componentInstanceMap = null;
    protected Class<? extends Annotation> scopeType;

    protected AbstractContext() {
    }

    @Override
    public <T> void initContextualBag(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        this.createContextualBag(contextual, creationalContext);
    }

    private <T> void createContextualBag(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        BeanInstanceBag<T> bag = new BeanInstanceBag<T>(creationalContext);
        if (this.componentInstanceMap instanceof ConcurrentMap) {
            BeanInstanceBag<T> exist = ((ConcurrentMap)this.componentInstanceMap).putIfAbsent(contextual, bag);
            if (exist == null) {
                this.componentInstanceMap.put(contextual, bag);
            }
        } else {
            this.componentInstanceMap.put(contextual, bag);
        }
    }

    protected AbstractContext(Class<? extends Annotation> scopeType) {
        this.scopeType = scopeType;
        this.setComponentInstanceMap();
    }

    protected AbstractContext(ContextTypes type) {
        this.type = type;
        this.configureScopeType(type);
        this.setComponentInstanceMap();
    }

    private void configureScopeType(ContextTypes type) {
        if (type.equals((Object)ContextTypes.APPLICATION)) {
            this.scopeType = ApplicationScoped.class;
        } else if (type.equals((Object)ContextTypes.SESSION)) {
            this.scopeType = SessionScoped.class;
        } else if (type.equals((Object)ContextTypes.REQUEST)) {
            this.scopeType = RequestScoped.class;
        } else if (type.equals((Object)ContextTypes.DEPENDENT)) {
            this.scopeType = Dependent.class;
        } else if (type.equals((Object)ContextTypes.CONVERSATION)) {
            this.scopeType = ConversationScoped.class;
        } else if (type.equals((Object)ContextTypes.SINGLETON)) {
            this.scopeType = Singleton.class;
        } else {
            throw new IllegalArgumentException("Not known scope type : " + type.toString());
        }
    }

    @Override
    public <T> T get(Contextual<T> component) {
        this.checkActive();
        if (this.componentInstanceMap.get(component) != null) {
            return (T)this.componentInstanceMap.get(component).getBeanInstance();
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        this.checkActive();
        return this.getInstance(contextual, creationalContext);
    }

    protected <T> T getInstance(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Object instance;
        BeanInstanceBag<?> bag = this.componentInstanceMap.get(contextual);
        if (bag == null) {
            this.createContextualBag(contextual, creationalContext);
            bag = this.componentInstanceMap.get(contextual);
        }
        if ((instance = bag.getBeanInstance()) != null) {
            return (T)instance;
        }
        if (creationalContext == null) {
            return null;
        }
        instance = bag.create(contextual);
        return (T)instance;
    }

    @Override
    public <T> CreationalContext<T> getCreationalContext(Contextual<T> contextual) {
        BeanInstanceBag<?> bag = this.componentInstanceMap.get(contextual);
        if (bag != null) {
            return bag.getBeanCreationalContext();
        }
        return null;
    }

    private <T> void destroyInstance(Contextual<T> component, T instance, CreationalContext<T> creationalContext) {
        component.destroy(instance, creationalContext);
    }

    @Override
    public void destroy() {
        Set<Map.Entry<Contextual<?>, BeanInstanceBag<?>>> entrySet = this.componentInstanceMap.entrySet();
        Iterator<Map.Entry<Contextual<?>, BeanInstanceBag<?>>> it = entrySet.iterator();
        while (it.hasNext()) {
            Contextual<?> contextual = it.next().getKey();
            BeanInstanceBag<?> instance = this.componentInstanceMap.get(contextual);
            CreationalContext<?> cc = instance.getBeanCreationalContext();
            this.destroyInstance(contextual, instance.getBeanInstance(), cc);
        }
        this.componentInstanceMap.clear();
        this.setActive(false);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public ContextTypes getType() {
        return this.type;
    }

    @Override
    public Map<Contextual<?>, BeanInstanceBag<?>> getComponentInstanceMap() {
        return this.componentInstanceMap;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    protected abstract void setComponentInstanceMap();

    protected void checkActive() {
        if (!this.active) {
            throw new ContextNotActiveException("WebBeans context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject((Object)this.type);
        s.writeObject(this.scopeType);
        if (this.componentInstanceMap != null) {
            SerializableBeanVault sbv = org.apache.webbeans.config.WebBeansContext.getInstance().getSerializableBeanVault();
            HashMap serializableInstanceMap = new HashMap();
            for (Map.Entry<Contextual<?>, BeanInstanceBag<?>> componentInstanceMapEntry : this.componentInstanceMap.entrySet()) {
                serializableInstanceMap.put(sbv.getSerializableBean(componentInstanceMapEntry.getKey()), componentInstanceMapEntry.getValue());
            }
            s.writeObject(serializableInstanceMap);
        } else {
            s.writeObject(null);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.type = (ContextTypes)((Object)s.readObject());
        this.scopeType = (Class)s.readObject();
        HashMap serializableInstanceMap = (HashMap)s.readObject();
        if (serializableInstanceMap != null) {
            this.setComponentInstanceMap();
            if (this.componentInstanceMap == null) {
                throw new NotSerializableException("componentInstanceMap not initialized!");
            }
            for (Map.Entry serializableInstanceMapEntry : serializableInstanceMap.entrySet()) {
                Contextual bean = (Contextual)serializableInstanceMapEntry.getKey();
                if (bean instanceof SerializableBean) {
                    this.componentInstanceMap.put(((SerializableBean)bean).getBean(), (BeanInstanceBag<?>)serializableInstanceMapEntry.getValue());
                    continue;
                }
                this.componentInstanceMap.put(bean, (BeanInstanceBag<?>)serializableInstanceMapEntry.getValue());
            }
        }
    }
}

