/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.webservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.Context;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.core.webservices.HandlerChainData;
import org.apache.openejb.core.webservices.HandlerData;
import org.apache.openejb.core.webservices.JaxWsUtils;

public class HandlerResolverImpl
implements HandlerResolver {
    private final List<HandlerChainData> handlerChains;
    private final Collection<Injection> injections;
    private final Context context;
    private final List<InjectionProcessor<Handler>> handlerInstances = new ArrayList<InjectionProcessor<Handler>>();

    public HandlerResolverImpl(List<HandlerChainData> handlerChains, Collection<Injection> injections, Context context) {
        this.handlerChains = handlerChains;
        this.injections = injections;
        this.context = context;
    }

    public void destroyHandlers() {
        ArrayList<InjectionProcessor<Handler>> handlerInstances = new ArrayList<InjectionProcessor<Handler>>(this.handlerInstances);
        this.handlerInstances.clear();
        for (InjectionProcessor injectionProcessor : handlerInstances) {
            injectionProcessor.preDestroy();
        }
    }

    @Override
    public List<Handler> getHandlerChain(PortInfo portInfo) {
        List<Handler> chain = new ArrayList<Handler>();
        for (HandlerChainData handlerChain : this.handlerChains) {
            List<Handler> handlers = this.buildHandlers(portInfo, handlerChain);
            handlers = this.sortHandlers(handlers);
            chain.addAll(handlers);
        }
        chain = this.sortHandlers(chain);
        return chain;
    }

    private List<Handler> buildHandlers(PortInfo portInfo, HandlerChainData handlerChain) {
        if (!(this.matchServiceName(portInfo, handlerChain.getServiceNamePattern()) && this.matchPortName(portInfo, handlerChain.getPortNamePattern()) && this.matchBinding(portInfo, handlerChain.getProtocolBindings()))) {
            return Collections.emptyList();
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(handlerChain.getHandlers().size());
        for (HandlerData handler : handlerChain.getHandlers()) {
            try {
                Class<Handler> handlerClass = handler.getHandlerClass().asSubclass(Handler.class);
                InjectionProcessor<Handler> processor = new InjectionProcessor<Handler>(handlerClass, this.injections, handler.getPostConstruct(), handler.getPreDestroy(), InjectionProcessor.unwrap(this.context));
                processor.createInstance();
                processor.postConstruct();
                Handler handlerInstance = processor.getInstance();
                handlers.add(handlerInstance);
                this.handlerInstances.add(processor);
            }
            catch (Exception e) {
                throw new WebServiceException("Failed to instantiate handler", e);
            }
        }
        return handlers;
    }

    private boolean matchServiceName(PortInfo info, QName namePattern) {
        return this.match(info == null ? null : info.getServiceName(), namePattern);
    }

    private boolean matchPortName(PortInfo info, QName namePattern) {
        return this.match(info == null ? null : info.getPortName(), namePattern);
    }

    private boolean matchBinding(PortInfo info, List bindings) {
        return this.match(info == null ? null : info.getBindingID(), bindings);
    }

    private boolean match(String binding, List bindings) {
        if (binding == null) {
            return bindings == null || bindings.isEmpty();
        }
        if (bindings == null || bindings.isEmpty()) {
            return true;
        }
        String actualBindingURI = JaxWsUtils.getBindingURI(binding);
        for (String bindingToken : bindings) {
            String bindingURI = JaxWsUtils.getBindingURI(bindingToken);
            if (!actualBindingURI.equals(bindingURI)) continue;
            return true;
        }
        return false;
    }

    private boolean match(QName name, QName namePattern) {
        if (name == null) {
            return namePattern == null || namePattern.getLocalPart().equals("*");
        }
        if (namePattern == null) {
            return true;
        }
        if (namePattern.getNamespaceURI() != null && !name.getNamespaceURI().equals(namePattern.getNamespaceURI())) {
            return false;
        }
        String localNamePattern = namePattern.getLocalPart();
        if (localNamePattern.equals("*")) {
            return true;
        }
        if (localNamePattern.endsWith("*")) {
            localNamePattern = localNamePattern.substring(0, localNamePattern.length() - 1);
            return name.getLocalPart().startsWith(localNamePattern);
        }
        return name.getLocalPart().equals(localNamePattern);
    }

    private List<Handler> sortHandlers(List<Handler> handlers) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<Handler> protocolHandlers = new ArrayList<Handler>();
        for (Handler handler : handlers) {
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            protocolHandlers.add(handler);
        }
        ArrayList<Handler> sortedHandlers = new ArrayList<Handler>();
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }
}

