/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;

public class RestrictedUserTransaction
implements UserTransaction {
    private final UserTransaction userTransaction;

    public RestrictedUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.checkAccess("begin");
        this.userTransaction.begin();
    }

    @Override
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.checkAccess("commit");
        this.userTransaction.commit();
    }

    @Override
    public int getStatus() throws SystemException {
        this.checkAccess("getStatus");
        return this.userTransaction.getStatus();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.checkAccess("rollback");
        this.userTransaction.rollback();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkAccess("setRollbackOnly");
        this.userTransaction.setRollbackOnly();
    }

    @Override
    public void setTransactionTimeout(int i) throws SystemException {
        this.checkAccess("setTransactionTimeout");
        this.userTransaction.setTransactionTimeout(i);
    }

    private void checkAccess(String methodName) {
        Operation operation = ThreadContext.getThreadContext().getCurrentOperation();
        if (operation == Operation.POST_CONSTRUCT) {
            throw new IllegalStateException("userTransaction." + methodName + "() not allowed in PostConstruct");
        }
    }
}

