/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionManagerContainer;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.OutboundNamedXAResourceFactory;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;

public abstract class AbstractConnectionManager
implements ConnectionManagerContainer,
ConnectionManager,
LazyAssociatableConnectionManager,
PoolingAttributes {
    protected final transient Interceptors interceptors;
    private final transient RecoverableTransactionManager transactionManager;
    private final transient ManagedConnectionFactory managedConnectionFactory;
    private final String name;

    public AbstractConnectionManager() {
        this.interceptors = null;
        this.transactionManager = null;
        this.managedConnectionFactory = null;
        this.name = null;
    }

    public AbstractConnectionManager(Interceptors interceptors, RecoverableTransactionManager transactionManager, ManagedConnectionFactory mcf, String name) {
        this.interceptors = interceptors;
        this.transactionManager = transactionManager;
        this.managedConnectionFactory = mcf;
        this.name = name;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.managedConnectionFactory.createConnectionFactory(this);
    }

    protected ConnectionManager getConnectionManager() {
        return this;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public void doRecovery() {
        if (!this.getIsRecoverable()) {
            return;
        }
        this.transactionManager.registerNamedXAResourceFactory(new OutboundNamedXAResourceFactory(this.name, this.getRecoveryStack(), this.managedConnectionFactory));
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ManagedConnectionInfo mci = new ManagedConnectionInfo(managedConnectionFactory, connectionRequestInfo);
        ConnectionInfo ci = new ConnectionInfo(mci);
        this.getStack().getConnection(ci);
        Object connection = ci.getConnectionProxy();
        if (connection == null) {
            connection = ci.getConnectionHandle();
        } else {
            ci.setConnectionProxy(null);
        }
        return connection;
    }

    public void associateConnection(Object connection, ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ManagedConnectionInfo mci = new ManagedConnectionInfo(managedConnectionFactory, connectionRequestInfo);
        ConnectionInfo ci = new ConnectionInfo(mci);
        ci.setConnectionHandle(connection);
        this.getStack().getConnection(ci);
    }

    public void inactiveConnectionClosed(Object connection, ManagedConnectionFactory managedConnectionFactory) {
    }

    ConnectionInterceptor getConnectionInterceptor() {
        return this.getStack();
    }

    public int getPartitionCount() {
        return this.getPooling().getPartitionCount();
    }

    public int getPartitionMaxSize() {
        return this.getPooling().getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.getPooling().setPartitionMaxSize(maxSize);
    }

    public int getPartitionMinSize() {
        return this.getPooling().getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.getPooling().setPartitionMinSize(minSize);
    }

    public int getIdleConnectionCount() {
        return this.getPooling().getIdleConnectionCount();
    }

    public int getConnectionCount() {
        return this.getPooling().getConnectionCount();
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.getPooling().getBlockingTimeoutMilliseconds();
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.getPooling().setBlockingTimeoutMilliseconds(timeoutMilliseconds);
    }

    public int getIdleTimeoutMinutes() {
        return this.getPooling().getIdleTimeoutMinutes();
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.getPooling().setIdleTimeoutMinutes(idleTimeoutMinutes);
    }

    private ConnectionInterceptor getStack() {
        return this.interceptors.getStack();
    }

    private ConnectionInterceptor getRecoveryStack() {
        return this.interceptors.getRecoveryStack();
    }

    private boolean getIsRecoverable() {
        return this.interceptors.getRecoveryStack() != null;
    }

    public PoolingSupport getPooling() {
        return this.interceptors.getPoolingAttributes();
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        if (this.transactionManager != null) {
            this.transactionManager.unregisterNamedXAResourceFactory(this.name);
        }
        this.interceptors.getStack().destroy();
    }

    public void doFail() {
        if (this.transactionManager != null) {
            this.transactionManager.unregisterNamedXAResourceFactory(this.name);
        }
        this.interceptors.getStack().destroy();
    }

    public static interface Interceptors {
        public ConnectionInterceptor getStack();

        public ConnectionInterceptor getRecoveryStack();

        public PoolingSupport getPoolingAttributes();
    }
}

