/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.ClientSecurity;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.proxy.InvocationHandler;

public abstract class EJBInvocationHandler
implements InvocationHandler,
Serializable {
    protected static final Method EQUALS = EJBInvocationHandler.getMethod(Object.class, "equals", Object.class);
    protected static final Method HASHCODE = EJBInvocationHandler.getMethod(Object.class, "hashCode", new Class[0]);
    protected static final Method TOSTRING = EJBInvocationHandler.getMethod(Object.class, "toString", new Class[0]);
    protected static final ConcurrentMap<Object, Set<WeakReference<EJBInvocationHandler>>> liveHandleRegistry = new ConcurrentHashMap<Object, Set<WeakReference<EJBInvocationHandler>>>();
    protected transient boolean inProxyMap = false;
    protected transient AtomicBoolean isInvalidReference = new AtomicBoolean(false);
    protected transient EJBRequest request;
    protected transient EJBMetaDataImpl ejb;
    protected transient ServerMetaData server;
    protected transient ClientMetaData client;
    protected transient Object primaryKey;
    protected final boolean remote;

    public EJBInvocationHandler() {
        this.remote = false;
    }

    public EJBInvocationHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        this.ejb = ejb;
        this.server = server;
        this.client = client;
        Class remoteInterface = ejb.getRemoteInterfaceClass();
        this.remote = remoteInterface != null && (EJBObject.class.isAssignableFrom(remoteInterface) || EJBHome.class.isAssignableFrom(remoteInterface));
    }

    public EJBInvocationHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        this(ejb, server, client);
        this.primaryKey = primaryKey;
    }

    public EJBMetaDataImpl getEjb() {
        return this.ejb;
    }

    public ServerMetaData getServer() {
        return this.server;
    }

    public ClientMetaData getClient() {
        return this.client;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    protected static Method getMethod(Class c, String method, Class ... params) {
        try {
            return c.getMethod(method, params);
        }
        catch (NoSuchMethodException nse) {
            throw new IllegalStateException("Cannot find method: " + c.getName() + "." + method, nse);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        if (this.isInvalidReference.get()) {
            if (this.remote || Remote.class.isAssignableFrom(method.getDeclaringClass())) {
                throw new NoSuchObjectException("reference is invalid");
            }
            throw new NoSuchEJBException("reference is invalid");
        }
        Object returnObj = this._invoke(proxy, method, args);
        return returnObj;
    }

    protected abstract Object _invoke(Object var1, Method var2, Object[] var3) throws Throwable;

    protected EJBResponse request(EJBRequest req) throws Exception {
        req.setClientIdentity(this.getClientIdentity());
        req.setServerHash(this.server.buildHash());
        EJBResponse response = new EJBResponse();
        Client.request(req, response, this.server);
        if (null != response.getServer()) {
            this.server.merge(response.getServer());
        }
        return response;
    }

    protected EJBResponse request(EJBRequest req, EJBResponse res) throws Exception {
        req.setClientIdentity(this.getClientIdentity());
        req.setServerHash(this.server.buildHash());
        Client.request(req, res, this.server);
        if (null != res.getServer()) {
            this.server.merge(res.getServer());
        }
        return res;
    }

    protected Object getClientIdentity() {
        Object identity;
        if (this.client != null && (identity = this.client.getClientIdentity()) != null) {
            return identity;
        }
        return ClientSecurity.getIdentity();
    }

    protected void invalidateReference() {
        this.isInvalidReference.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void invalidateAllHandlers(Object key) {
        Set set = (Set)liveHandleRegistry.remove(key);
        if (set == null) {
            return;
        }
        Set set2 = set;
        synchronized (set2) {
            for (WeakReference ref : set) {
                EJBInvocationHandler handler = (EJBInvocationHandler)ref.get();
                if (handler == null) continue;
                handler.invalidateReference();
            }
            set.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerHandler(Object key, EJBInvocationHandler handler) {
        Set current;
        Set<WeakReference<EJBInvocationHandler>> set = (HashSet<WeakReference<EJBInvocationHandler>>)liveHandleRegistry.get(key);
        if (set == null && (current = (Set)liveHandleRegistry.putIfAbsent(key, set = new HashSet<WeakReference<EJBInvocationHandler>>())) != null) {
            set = current;
        }
        HashSet<WeakReference<EJBInvocationHandler>> hashSet = set;
        synchronized (hashSet) {
            set.add(new WeakReference<EJBInvocationHandler>(handler));
        }
    }

    protected Throwable convertException(Throwable e, Method method) {
        if (!this.remote && e instanceof RemoteException) {
            if (e instanceof TransactionRequiredException) {
                return new TransactionRequiredLocalException(e.getMessage()).initCause(EJBInvocationHandler.getCause(e));
            }
            if (e instanceof TransactionRolledbackException) {
                return new TransactionRolledbackLocalException(e.getMessage()).initCause(EJBInvocationHandler.getCause(e));
            }
            if (e instanceof NoSuchObjectException) {
                if (Remote.class.isAssignableFrom(method.getDeclaringClass())) {
                    return e;
                }
                return new NoSuchEJBException(e.getMessage()).initCause(EJBInvocationHandler.getCause(e));
            }
            if (e instanceof AccessException) {
                return new AccessLocalException(e.getMessage()).initCause(EJBInvocationHandler.getCause(e));
            }
            return new EJBException(e.getMessage()).initCause(EJBInvocationHandler.getCause(e));
        }
        if (this.remote && e instanceof EJBAccessException) {
            if (e.getCause() instanceof Exception) {
                return new AccessException(e.getMessage(), (Exception)e.getCause());
            }
            return new AccessException(e.getMessage());
        }
        if (!this.remote && e instanceof EJBTransactionRolledbackException) {
            return new TransactionRolledbackLocalException(e.getMessage()).initCause(EJBInvocationHandler.getCause(e));
        }
        return e;
    }

    protected static Throwable getCause(Throwable e) {
        if (e != null && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }
}

