/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.IOException;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.io.CachingNameResolver;
import org.apache.myfaces.trinidadinternal.share.io.InputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.xml.JaxpXMLProvider;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetParserUtils;
import org.apache.myfaces.trinidadinternal.skin.StyleSheetNameResolver;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.xml.StyleSheetDocumentUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;

class StyleSheetEntry {
    private String _name;
    private StyleSheetDocument _document;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetEntry.class);

    public static StyleSheetEntry createEntry(StyleContext context, String styleSheetName) {
        NameResolver resolver = StyleSheetEntry._getNameResolver(context);
        if (resolver == null) {
            return null;
        }
        StyleSheetEntry skinStyleSheet = StyleSheetEntry._createSkinStyleSheet(resolver, styleSheetName);
        if (skinStyleSheet == null) {
            return null;
        }
        if (context.checkStylesModified() || context.isDirty()) {
            return new CheckModifiedEntry(styleSheetName, skinStyleSheet.getDocument(), resolver);
        }
        return skinStyleSheet;
    }

    StyleSheetEntry(String styleSheetName, StyleSheetDocument document) {
        this._name = styleSheetName;
        this._document = document;
    }

    StyleSheetEntry(String styleSheetName) {
        this(styleSheetName, null);
    }

    private StyleSheetEntry() {
    }

    public String getStyleSheetName() {
        return this._name;
    }

    public StyleSheetDocument getDocument() {
        return this._document;
    }

    public boolean checkModified(StyleContext context) {
        return false;
    }

    void __setDocument(StyleSheetDocument document) {
        this._document = document;
    }

    private static StyleSheetEntry _createSkinStyleSheet(NameResolver resolver, String styleSheetName) {
        StyleSheetDocument document;
        Object skinStyleSheet = !styleSheetName.endsWith(".css") ? ((document = StyleSheetEntry._createStyleSheetDocumentFromXSS(resolver, styleSheetName)) == null ? null : new StyleSheetEntry(styleSheetName, document)) : StyleSheetEntry._createSkinStyleSheetFromCSS(resolver, styleSheetName);
        return skinStyleSheet;
    }

    private static StyleSheetEntry _createSkinStyleSheetFromCSS(NameResolver resolver, String styleSheetName) {
        try {
            ParseContextImpl parseContext = new ParseContextImpl();
            return SkinStyleSheetParserUtils.parseCSSSource(parseContext, resolver, styleSheetName, StyleSheetEntry.class);
        }
        catch (Exception e) {
            if (_LOG.isSevere()) {
                _LOG.severe("CANNOT_LOAD_STYLESHEET", (Object)styleSheetName);
            }
            _LOG.severe((Throwable)e);
            return null;
        }
    }

    private static StyleSheetDocument _createStyleSheetDocumentFromXSS(NameResolver resolver, String styleSheetName) {
        JaxpXMLProvider xmlProvider = new JaxpXMLProvider();
        try {
            return StyleSheetDocumentUtils.createStyleSheetDocument(xmlProvider, resolver, styleSheetName);
        }
        catch (Exception e) {
            if (_LOG.isSevere()) {
                _LOG.severe("CANNOT_LOAD_STYLESHEET", (Object)styleSheetName);
            }
            _LOG.severe((Throwable)e);
            return null;
        }
    }

    private static NameResolver _getNameResolver(StyleContext context) {
        NameResolver resolver = StyleSheetNameResolver.createResolver(context);
        if (resolver == null) {
            return null;
        }
        return new CachingNameResolver(resolver, null, true);
    }

    private static class CheckModifiedEntry
    extends StyleSheetEntry {
        private InputStreamProvider _provider;

        public CheckModifiedEntry(String styleSheetName, StyleSheetDocument document, NameResolver resolver) {
            super(styleSheetName, document);
            this._provider = this._getInputStreamProvider(resolver);
        }

        public boolean checkModified(StyleContext context) {
            if (context.isDirty() || this._provider != null && this._provider.hasSourceChanged()) {
                this._provider = null;
                this.__setDocument(null);
                NameResolver resolver = StyleSheetEntry._getNameResolver(context);
                if (resolver != null) {
                    String name = this.getStyleSheetName();
                    StyleSheetEntry skinStyleSheet = StyleSheetEntry._createSkinStyleSheet(resolver, name);
                    if (skinStyleSheet != null) {
                        this._provider = this._getInputStreamProvider(resolver);
                        this.__setDocument(skinStyleSheet.getDocument());
                    }
                    return true;
                }
            }
            return false;
        }

        private InputStreamProvider _getInputStreamProvider(NameResolver resolver) {
            assert (resolver instanceof CachingNameResolver);
            try {
                return resolver.getProvider(this.getStyleSheetName());
            }
            catch (IOException e) {
                assert (false);
                return null;
            }
        }
    }
}

