/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlTableLayout;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class TableLayoutRenderer
extends XhtmlRenderer {
    private PropertyKey _widthKey;
    private PropertyKey _halignKey;
    private PropertyKey _cellSpacingKey;
    private PropertyKey _cellPaddingKey;
    private PropertyKey _borderWidthKey;
    private PropertyKey _summaryKey;

    public TableLayoutRenderer() {
        super(HtmlTableLayout.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._widthKey = type.findKey("width");
        this._halignKey = type.findKey("halign");
        this._cellSpacingKey = type.findKey("cellSpacing");
        this._cellPaddingKey = type.findKey("cellPadding");
        this._borderWidthKey = type.findKey("borderWidth");
        this._summaryKey = type.findKey("summary");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("table", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        TableLayoutRenderer.renderHAlign(context, arc, this.getHalign(bean));
        OutputUtils.renderDataTableAttributes(context, arc, this.getCellPadding(bean), this.getCellSpacing(bean), this.getBorderWidth(bean), this.getWidth(bean), this.getSummary(bean));
        this.encodeAllChildren(context, component);
        rw.endElement("table");
    }

    protected Object getWidth(FacesBean bean) {
        return bean.getProperty(this._widthKey);
    }

    protected Object getHalign(FacesBean bean) {
        return bean.getProperty(this._halignKey);
    }

    protected Object getCellSpacing(FacesBean bean) {
        Object o = bean.getProperty(this._cellSpacingKey);
        if (o == null) {
            o = 0;
        }
        return o;
    }

    protected Object getCellPadding(FacesBean bean) {
        Object o = bean.getProperty(this._cellPaddingKey);
        if (o == null) {
            o = 0;
        }
        return o;
    }

    protected Object getBorderWidth(FacesBean bean) {
        Object o = bean.getProperty(this._borderWidthKey);
        if (o == null) {
            o = 0;
        }
        return o;
    }

    protected Object getSummary(FacesBean bean) {
        Object o = bean.getProperty(this._summaryKey);
        if (o == null) {
            o = "";
        }
        return o;
    }
}

