/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractAPTMojo
extends AbstractMojo {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int APT_COMPILER_SUCCESS = 0;
    private static final String APT_ENTRY_POINT = "com.sun.tools.apt.Main";
    private static final String APT_METHOD_NAME = "process";
    private static final String APT_METHOD_NAME_OLD = "compile";
    private static boolean isClasspathModified;
    private File workingDir;
    private List targetFiles;
    private boolean resourceFiltering;
    private String resourceTargetPath;
    private boolean debug;
    private String aptOptions;
    private boolean showDeprecation;
    private boolean showWarnings;
    private String encoding;
    private boolean verbose;
    private boolean nocompile;
    private int staleMillis;
    private String factory;
    private File tempRoot;
    private File basedir;
    private boolean fork;
    private boolean force;
    private MavenProject project;

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getStaleMillis() {
        return this.staleMillis;
    }

    protected List getTargetFiles() {
        return this.targetFiles;
    }

    protected boolean isResourceFiltering() {
        return this.resourceFiltering;
    }

    protected String getResourceTargetPath() {
        return this.resourceTargetPath;
    }

    protected abstract List getClasspathElements();

    protected abstract List getCompileSourceRoots();

    protected abstract List getAptSourceRoots();

    protected abstract File getOutputDirectory();

    protected abstract String getGenerated();

    protected abstract SourceInclusionScanner getSourceInclusionScanner();

    public void execute() throws MojoExecutionException {
        block28: {
            this.getLog().debug((CharSequence)"Using apt compiler");
            org.codehaus.plexus.compiler.javac.Commandline cmd = new org.codehaus.plexus.compiler.javac.Commandline();
            int result = 0;
            StringWriter writer = new StringWriter();
            try {
                this.setAptCommandlineSwitches(cmd);
                this.setAptSpecifics(cmd);
                this.setStandards(cmd);
                this.setClasspath(cmd);
                ArrayList sourceFiles = new ArrayList();
                if (!this.fillSourcelist(sourceFiles)) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)"there are not stale sources.");
                    }
                    return;
                }
                if (this.fork) {
                    if (!this.tempRoot.exists()) {
                        this.tempRoot.mkdirs();
                    }
                    File file = new File(this.tempRoot, "files");
                    if (!this.getLog().isDebugEnabled()) {
                        file.deleteOnExit();
                    }
                    try {
                        FileUtils.fileWrite((String)file.getAbsolutePath(), (String)StringUtils.join(sourceFiles.iterator(), (String)"\n"));
                        cmd.createArgument().setValue('@' + file.getPath());
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to write temporary file for command execution", (Exception)e);
                    }
                } else {
                    Iterator sourceIt = sourceFiles.iterator();
                    while (sourceIt.hasNext()) {
                        this.cmdAdd(cmd, (String)sourceIt.next());
                    }
                }
                if (this.fork) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Working dir: " + this.workingDir.getAbsolutePath()));
                    }
                    cmd.setWorkingDirectory(this.workingDir.getAbsolutePath());
                    cmd.setExecutable(this.getAptPath());
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Invoking apt with cmd " + org.codehaus.plexus.compiler.javac.Commandline.toString((String[])cmd.getShellCommandline())));
                    }
                    CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
                    try {
                        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)err);
                        this.getLog().error((CharSequence)err.getOutput());
                        if (exitCode != 0) {
                            throw new MojoExecutionException("Exit code: " + exitCode + " - " + err.getOutput());
                        }
                        break block28;
                    }
                    catch (CommandLineException e) {
                        throw new MojoExecutionException("Unable to execute apt command", (Exception)((Object)e));
                    }
                }
                if (!isClasspathModified) {
                    URL toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar").toURL();
                    Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    m.setAccessible(true);
                    ((Object)((Object)this)).getClass().getClassLoader();
                    m.invoke((Object)ClassLoader.getSystemClassLoader(), toolsJar);
                    isClasspathModified = true;
                }
                ((Object)((Object)this)).getClass();
                Class<?> c = Class.forName(APT_ENTRY_POINT);
                Object compiler = c.newInstance();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Invoking apt with cmd " + cmd.toString()));
                }
                try {
                    Method compile = c.getMethod(APT_METHOD_NAME, PrintWriter.class, new String[0].getClass());
                    result = (Integer)compile.invoke(compiler, new PrintWriter(writer), cmd.getArguments());
                }
                catch (NoSuchMethodException e) {
                    Method compile = c.getMethod(APT_METHOD_NAME_OLD, new String[0].getClass(), PrintWriter.class);
                    result = (Integer)compile.invoke(compiler, cmd.getArguments(), new PrintWriter(writer));
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error starting apt compiler", ex);
            }
            finally {
                if (result != 0) {
                    throw new MojoExecutionException((Object)this, "Compilation error.", writer.getBuffer().toString());
                }
                if (this.getLog().isDebugEnabled()) {
                    String r = writer.getBuffer().toString();
                    if (0 != r.length()) {
                        this.getLog().debug((CharSequence)r);
                    }
                    this.getLog().debug((CharSequence)"Apt finished.");
                }
            }
        }
    }

    private void setAptCommandlineSwitches(org.codehaus.plexus.compiler.javac.Commandline cmd) {
        if (null == this.aptOptions) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.aptOptions.trim(), ",");
        while (tokenizer.hasMoreElements()) {
            String option = tokenizer.nextToken().trim();
            if (!option.startsWith("-A")) {
                option = "-A" + option;
            }
            this.cmdAdd(cmd, option);
        }
    }

    private void setAptSpecifics(org.codehaus.plexus.compiler.javac.Commandline cmd) throws MojoExecutionException {
        try {
            String g = this.basedir.getAbsolutePath() + FILE_SEPARATOR + this.getGenerated();
            File generatedDir = new File(g);
            this.cmdAdd(cmd, "-s", generatedDir.getCanonicalPath());
            if (!generatedDir.exists()) {
                generatedDir.mkdirs();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Generated directory is invalid.", e);
        }
        if (this.nocompile) {
            this.cmdAdd(cmd, "-nocompile");
        }
        if (null != this.factory && 0 != this.factory.length()) {
            this.cmdAdd(cmd, "-factory", this.factory);
        }
    }

    private void setStandards(org.codehaus.plexus.compiler.javac.Commandline cmd) throws MojoExecutionException {
        if (this.debug) {
            this.cmdAdd(cmd, "-g");
        }
        if (!this.showWarnings) {
            this.cmdAdd(cmd, "-nowarn");
        }
        if (this.showDeprecation) {
            this.cmdAdd(cmd, "-depecation");
        }
        if (null != this.encoding) {
            this.cmdAdd(cmd, "-encoding", this.encoding);
        }
        if (this.verbose) {
            this.cmdAdd(cmd, "-verbose");
        }
        this.setSourcepath(cmd);
        try {
            if (!this.getOutputDirectory().exists()) {
                this.getOutputDirectory().mkdirs();
            }
            this.cmdAdd(cmd, "-d", this.getOutputDirectory().getCanonicalPath());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Output directory is invalid.", ex);
        }
    }

    private void setSourcepath(org.codehaus.plexus.compiler.javac.Commandline cmd) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.getCompileSourceRoots().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(PATH_SEPARATOR);
        }
        if (this.getAptSourceRoots() != null) {
            if (buffer.length() > 0 && this.getAptSourceRoots().size() > 0) {
                buffer.append(PATH_SEPARATOR);
            }
            it = this.getAptSourceRoots().iterator();
            while (it.hasNext()) {
                buffer.append(it.next());
                if (!it.hasNext()) continue;
                buffer.append(PATH_SEPARATOR);
            }
        }
        this.cmdAdd(cmd, "-sourcepath", buffer.toString());
    }

    private boolean fillSourcelist(List cmd) throws MojoExecutionException {
        boolean has = false;
        Iterator it = this.getCompileSourceRoots().iterator();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Checking sourcepath");
        }
        while (it.hasNext()) {
            File srcFile = new File((String)it.next());
            has = this.addIncludedSources(srcFile, cmd, has);
        }
        List aptSourcesRoots = this.getAptSourceRoots();
        if (aptSourcesRoots != null) {
            it = aptSourcesRoots.iterator();
            while (it.hasNext()) {
                File srcFile = new File((String)it.next());
                has = this.addIncludedSources(srcFile, cmd, has);
            }
        }
        return has;
    }

    private boolean addIncludedSources(File srcFile, List cmd, boolean has) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Checking sourcepath in " + srcFile));
        }
        if (srcFile.isDirectory()) {
            Set sources = null;
            try {
                sources = this.getSourceInclusionScanner().getIncludedSources(srcFile, this.getOutputDirectory());
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Can't agregate sources.", ex);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("sources from: " + srcFile.getAbsolutePath()));
                String s = "";
                Iterator jt = sources.iterator();
                while (jt.hasNext()) {
                    s = s + jt.next() + "\n";
                }
                this.getLog().debug((CharSequence)s);
            }
            for (File src : sources) {
                if (this.fork) {
                    cmd.add(this.quotedPathArgument(src.getAbsolutePath()));
                } else {
                    cmd.add(src.getAbsolutePath());
                }
                has = true;
            }
        }
        return has;
    }

    private void setClasspath(org.codehaus.plexus.compiler.javac.Commandline cmd) throws MojoExecutionException, DependencyResolutionRequiredException {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.getClasspathElements().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(PATH_SEPARATOR);
        }
        this.cmdAdd(cmd, "-classpath", buffer.toString());
    }

    private void cmdAdd(org.codehaus.plexus.compiler.javac.Commandline cmd, String arg) {
        cmd.createArgument().setValue(arg);
    }

    private void cmdAdd(org.codehaus.plexus.compiler.javac.Commandline cmd, String arg1, String arg2) {
        this.cmdAdd(cmd, arg1);
        this.cmdAdd(cmd, arg2);
    }

    private String getAptPath() {
        String aptCommand = "apt";
        if (Os.isFamily((String)"windows")) {
            aptCommand = "apt.exe";
        }
        File aptExe = Os.isName((String)"aix") ? new File(System.getProperty("java.home") + "/../sh", aptCommand) : (Os.isFamily((String)"unix") && Os.isFamily((String)"mac") ? new File(System.getProperty("java.home") + "/bin", aptCommand) : new File(System.getProperty("java.home") + "/../bin", aptCommand));
        this.getLog().debug((CharSequence)("Apt executable=[" + aptExe.getAbsolutePath() + "]"));
        return aptExe.getAbsolutePath();
    }

    private String quotedPathArgument(String value) {
        String path = value;
        if (!StringUtils.isEmpty((String)path)) {
            if ((path = path.replace('\\', '/')).indexOf("'") != -1) {
                String[] split = path.split("'");
                path = "";
                for (int i = 0; i < split.length; ++i) {
                    path = i != split.length - 1 ? path + split[i] + "\\'" : path + split[i];
                }
            }
            path = "'" + path + "'";
        }
        return path;
    }
}

