/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.surefire.testng.conf.AbstractDirectConfigurator;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.TestNG;
import org.testng.xml.XmlSuite;

public class TestNGMapConfigurator
implements Configurator {
    @Override
    public void configure(TestNG testng, Map<String, String> options) throws TestSetFailedException {
        Map<String, Object> convertedOptions = this.getConvertedOptions(options);
        testng.configure(convertedOptions);
    }

    @Override
    public void configure(XmlSuite suite, Map<String, String> options) throws TestSetFailedException {
        String threadCountAsString = options.get("threadcount");
        int threadCount = threadCountAsString == null ? 1 : Integer.parseInt(threadCountAsString);
        suite.setThreadCount(threadCount);
        String parallel = options.get("parallel");
        if (parallel != null) {
            suite.setParallel(parallel);
        }
    }

    Map<String, Object> getConvertedOptions(Map<String, String> options) throws TestSetFailedException {
        HashMap<String, Object> convertedOptions = new HashMap<String, Object>();
        convertedOptions.put("-mixed", false);
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            switch (key) {
                case "listener": {
                    val = this.convertListeners(entry.getValue());
                    break;
                }
                case "objectfactory": 
                case "testrunfactory": {
                    val = AbstractDirectConfigurator.loadClass(entry.getValue());
                    break;
                }
                case "reporter": {
                    val = this.convertReporterConfig(val);
                    key = "reporterslist";
                    break;
                }
                case "junit": 
                case "skipfailedinvocationcounts": 
                case "mixed": 
                case "group-by-instances": {
                    val = this.convert(val, Boolean.class);
                    break;
                }
                case "configfailurepolicy": 
                case "threadcount": {
                    val = this.convert(val, String.class);
                    break;
                }
                case "suitethreadpoolsize": 
                case "dataproviderthreadcount": {
                    val = this.convert(val, Integer.class);
                    break;
                }
            }
            if (key.startsWith("-")) {
                convertedOptions.put(key, val);
                continue;
            }
            convertedOptions.put("-" + key, val);
        }
        return convertedOptions;
    }

    protected Object convertReporterConfig(Object val) {
        try {
            Class<?> reporterConfig = Class.forName("org.testng.ReporterConfig");
            Method deserialize = reporterConfig.getMethod("deserialize", String.class);
            Object rc = deserialize.invoke(null, val);
            ArrayList<Object> reportersList = new ArrayList<Object>();
            reportersList.add(rc);
            return reportersList;
        }
        catch (Exception e) {
            return val;
        }
    }

    protected Object convertListeners(String listenerClasses) throws TestSetFailedException {
        return AbstractDirectConfigurator.loadListenerClasses(listenerClasses);
    }

    protected Object convert(Object val, Class<?> type) {
        if (val == null) {
            return null;
        }
        if (type.isAssignableFrom(val.getClass())) {
            return val;
        }
        if ((type == Boolean.class || type == Boolean.TYPE) && val.getClass() == String.class) {
            return Boolean.valueOf((String)val);
        }
        if ((type == Integer.class || type == Integer.TYPE) && val.getClass() == String.class) {
            return Integer.valueOf((String)val);
        }
        if (type == String.class) {
            return val.toString();
        }
        return val;
    }
}

