/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.MulticastingReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunReporter;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.SystemStreamCapturer;

public class ReporterManager
implements Reporter,
RunReporter {
    private final RunStatistics runStatisticsForThis;
    private final MulticastingReporter multicastingReporter;
    private final RunReporter runReporter;
    private final SystemStreamCapturer consoleCapturer;

    public ReporterManager(List reports, RunStatistics runStatisticsForThis, SystemStreamCapturer systemStreamCapturer) {
        this.consoleCapturer = systemStreamCapturer;
        this.multicastingReporter = new MulticastingReporter(reports);
        this.runReporter = this.multicastingReporter;
        this.runStatisticsForThis = runStatisticsForThis;
    }

    protected ReporterManager(ReporterManager other) {
        this.multicastingReporter = other.multicastingReporter;
        this.runReporter = other.multicastingReporter;
        this.runStatisticsForThis = other.runStatisticsForThis;
        this.consoleCapturer = other.consoleCapturer;
    }

    public void writeMessage(String message) {
        this.multicastingReporter.writeMessage(message);
    }

    public void writeConsoleMessage(String message) {
        this.multicastingReporter.writeConsoleMessage(message);
    }

    public void writeDetailMessage(String message) {
        this.multicastingReporter.writeDetailMessage(message);
    }

    public void runStarting() {
        this.multicastingReporter.runStarting();
    }

    public void runCompleted() {
        Iterator iterator;
        this.multicastingReporter.runCompleted();
        this.multicastingReporter.writeFooter("");
        this.multicastingReporter.writeFooter("Results :");
        this.multicastingReporter.writeFooter("");
        if (this.runStatisticsForThis.hadFailures()) {
            this.multicastingReporter.writeFooter("Failed tests: ");
            iterator = this.runStatisticsForThis.getFailureSources().iterator();
            while (iterator.hasNext()) {
                this.multicastingReporter.writeFooter("  " + iterator.next());
            }
            this.multicastingReporter.writeFooter("");
        }
        if (this.runStatisticsForThis.hadErrors()) {
            this.writeFooter("Tests in error: ");
            iterator = this.runStatisticsForThis.getErrorSources().iterator();
            while (iterator.hasNext()) {
                this.multicastingReporter.writeFooter("  " + iterator.next());
            }
            this.multicastingReporter.writeFooter("");
        }
        this.multicastingReporter.writeFooter(this.runStatisticsForThis.getSummary());
        this.multicastingReporter.writeFooter("");
        this.consoleCapturer.restoreStreams();
    }

    public void writeFooter(String footer) {
        this.multicastingReporter.writeFooter(footer);
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        this.multicastingReporter.testSetStarting(report);
    }

    public void testSetCompleted(ReportEntry report) {
        this.multicastingReporter.testSetCompleted(report);
    }

    public void testStarting(ReportEntry report) {
        this.multicastingReporter.testStarting(report);
    }

    public void testSucceeded(ReportEntry report) {
        this.consoleCapturer.clearCapturedContent();
        this.runStatisticsForThis.incrementCompletedCount();
        this.multicastingReporter.testSucceeded(report);
    }

    public void testError(ReportEntry reportEntry) {
        this.testError(reportEntry, this.consoleCapturer.getStdOutLog(), this.consoleCapturer.getStdErrLog());
    }

    public void testError(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testError(reportEntry, stdOutLog, stdErrLog);
        this.runStatisticsForThis.incrementErrorsCount();
        this.runStatisticsForThis.incrementCompletedCount();
        this.runStatisticsForThis.addErrorSource(reportEntry.getName());
        this.consoleCapturer.clearCapturedContent();
    }

    public void testFailed(ReportEntry reportEntry) {
        this.testFailed(reportEntry, this.consoleCapturer.getStdOutLog(), this.consoleCapturer.getStdErrLog());
    }

    public void testFailed(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testFailed(reportEntry, stdOutLog, stdErrLog);
        this.runStatisticsForThis.incrementFailureCount();
        this.runStatisticsForThis.incrementCompletedCount();
        this.runStatisticsForThis.addFailureSource(reportEntry.getName());
        this.consoleCapturer.clearCapturedContent();
    }

    public void testSkipped(ReportEntry report) {
        this.consoleCapturer.clearCapturedContent();
        this.runStatisticsForThis.incrementSkippedCount();
        this.runStatisticsForThis.incrementCompletedCount();
        this.multicastingReporter.testSkipped(report);
    }

    public void reset() {
        this.multicastingReporter.reset();
    }
}

