/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.suite;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class RunResult {
    private final int completedCount;
    private final int errors;
    private final int failures;
    private final int skipped;
    private final int flakes;
    private final String failure;
    private final boolean timeout;
    public static final int SUCCESS = 0;
    private static final int FAILURE = 255;
    private static final int NO_TESTS = 254;

    public static RunResult timeout(RunResult accumulatedAtTimeout) {
        return RunResult.errorCode(accumulatedAtTimeout, accumulatedAtTimeout.getFailure(), true);
    }

    public static RunResult failure(RunResult accumulatedAtTimeout, Exception cause) {
        return RunResult.errorCode(accumulatedAtTimeout, RunResult.getStackTrace(cause), accumulatedAtTimeout.isTimeout());
    }

    private static RunResult errorCode(RunResult other, String failure, boolean timeout) {
        return new RunResult(other.getCompletedCount(), other.getErrors(), other.getFailures(), other.getSkipped(), failure, timeout);
    }

    public RunResult(int completedCount, int errors, int failures, int skipped) {
        this(completedCount, errors, failures, skipped, null, false);
    }

    public RunResult(int completedCount, int errors, int failures, int skipped, int flakes) {
        this(completedCount, errors, failures, skipped, flakes, null, false);
    }

    public RunResult(int completedCount, int errors, int failures, int skipped, String failure, boolean timeout) {
        this(completedCount, errors, failures, skipped, 0, failure, timeout);
    }

    public RunResult(int completedCount, int errors, int failures, int skipped, int flakes, String failure, boolean timeout) {
        this.completedCount = completedCount;
        this.errors = errors;
        this.failures = failures;
        this.skipped = skipped;
        this.failure = failure;
        this.timeout = timeout;
        this.flakes = flakes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTrace(Exception e) {
        if (e == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        try {
            e.printStackTrace(pw);
            pw.flush();
        }
        finally {
            pw.close();
        }
        return new String(out.toByteArray());
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFlakes() {
        return this.flakes;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public Integer getFailsafeCode() {
        if (this.completedCount == 0) {
            return 254;
        }
        if (!this.isErrorFree()) {
            return 255;
        }
        return null;
    }

    public boolean isErrorFree() {
        return this.getFailures() == 0 && this.getErrors() == 0 && !this.isFailure();
    }

    public boolean isInternalError() {
        return this.getFailures() == 0 && this.getErrors() == 0 && this.isFailure();
    }

    public boolean isFailureOrTimeout() {
        return this.isTimeout() || this.isFailure();
    }

    public boolean isFailure() {
        return this.failure != null;
    }

    public String getFailure() {
        return this.failure;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public RunResult aggregate(RunResult other) {
        String failureMessage = this.getFailure() != null ? this.getFailure() : other.getFailure();
        boolean timeout = this.isTimeout() || other.isTimeout();
        int completed = this.getCompletedCount() + other.getCompletedCount();
        int fail = this.getFailures() + other.getFailures();
        int ign = this.getSkipped() + other.getSkipped();
        int err = this.getErrors() + other.getErrors();
        int flakes = this.getFlakes() + other.getFlakes();
        return new RunResult(completed, err, fail, ign, flakes, failureMessage, timeout);
    }

    public static RunResult noTestsRun() {
        return new RunResult(0, 0, 0, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunResult runResult = (RunResult)o;
        if (this.completedCount != runResult.completedCount) {
            return false;
        }
        if (this.errors != runResult.errors) {
            return false;
        }
        if (this.failures != runResult.failures) {
            return false;
        }
        if (this.skipped != runResult.skipped) {
            return false;
        }
        if (this.timeout != runResult.timeout) {
            return false;
        }
        return !(this.failure != null ? !this.failure.equals(runResult.failure) : runResult.failure != null);
    }

    public int hashCode() {
        int result = this.completedCount;
        result = 31 * result + this.errors;
        result = 31 * result + this.failures;
        result = 31 * result + this.skipped;
        result = 31 * result + (this.failure != null ? this.failure.hashCode() : 0);
        result = 31 * result + (this.timeout ? 1 : 0);
        return result;
    }
}

