/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.TestsToRun;

public class LazyTestsToRun
extends TestsToRun {
    private List workQueue = new ArrayList();
    private BufferedReader inputReader;
    private boolean streamClosed = false;
    private ClassLoader testClassLoader;
    private PrintStream originalOutStream;

    public LazyTestsToRun(InputStream testSource, ClassLoader testClassLoader, PrintStream originalOutStream) {
        super(Collections.emptyList());
        this.testClassLoader = testClassLoader;
        this.originalOutStream = originalOutStream;
        this.inputReader = new BufferedReader(new InputStreamReader(testSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWorkItem(String className) {
        List list = this.workQueue;
        synchronized (list) {
            this.workQueue.add(ReflectionUtils.loadClass(this.testClassLoader, className));
        }
    }

    protected void requestNextTest() {
        StringBuffer sb = new StringBuffer();
        sb.append('N').append(",0,want more!\n");
        this.originalOutStream.print(sb.toString());
    }

    public Iterator iterator() {
        return new BlockingIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("LazyTestsToRun ");
        List list = this.workQueue;
        synchronized (list) {
            sb.append("(more items expected: ").append(!this.streamClosed).append("): ");
            sb.append(this.workQueue);
        }
        return sb.toString();
    }

    public boolean allowEagerReading() {
        return false;
    }

    private class BlockingIterator
    implements Iterator {
        private int lastPos = -1;

        private BlockingIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            int nextPos = this.lastPos + 1;
            List list = LazyTestsToRun.this.workQueue;
            synchronized (list) {
                if (LazyTestsToRun.this.workQueue.size() > nextPos) {
                    return true;
                }
                if (this.needsToWaitForInput(nextPos)) {
                    String nextClassName;
                    LazyTestsToRun.this.requestNextTest();
                    try {
                        nextClassName = LazyTestsToRun.this.inputReader.readLine();
                    }
                    catch (IOException e) {
                        LazyTestsToRun.this.streamClosed = true;
                        return false;
                    }
                    if (null == nextClassName) {
                        LazyTestsToRun.this.streamClosed = true;
                    } else {
                        LazyTestsToRun.this.addWorkItem(nextClassName);
                    }
                }
                return LazyTestsToRun.this.workQueue.size() > nextPos;
            }
        }

        private boolean needsToWaitForInput(int nextPos) {
            return LazyTestsToRun.this.workQueue.size() == nextPos && !LazyTestsToRun.this.streamClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            List list = LazyTestsToRun.this.workQueue;
            synchronized (list) {
                return LazyTestsToRun.this.workQueue.get(++this.lastPos);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

